import java.io.*;
import java.net.*;
import javax.xml.stream.*;

/**
 * Program demonstrujcy wykorzystanie parsera StAX.
 * Wywietla wszystkie hipercza umiesczone na stronie XHTML.
 * Uruchomienie programu: java StAXTest url
 * @author Cay Horstmann
 * @version 1.0 2007-06-23
 */
public class StAXTest
{
   public static void main(String[] args) throws Exception
   {
      String urlString;
      if (args.length == 0)
      {
         urlString = "http://www.w3c.org";
         System.out.println("Using " + urlString);
      }
      else urlString = args[0];
      URL url = new URL(urlString);
      InputStream in = url.openStream();
      XMLInputFactory factory = XMLInputFactory.newInstance();
      XMLStreamReader parser = factory.createXMLStreamReader(in);
      while (parser.hasNext())
      {
         int event = parser.next();
         if (event == XMLStreamConstants.START_ELEMENT)
         {
            if (parser.getLocalName().equals("a")) 
            {
               String href = parser.getAttributeValue(null, "href");
               if (href != null)
                  System.out.println(href);               
            }
         }
      }
   }
}
