package com.brackeen.javagamebook.state;

import java.awt.Image;
import java.awt.Graphics2D;
import java.util.*;
import com.brackeen.javagamebook.input.InputManager;

public class GameStateManager {

    public static final String EXIT_GAME = "_ExitGame";

    private Map gameStates;
    private Image defaultImage;
    private GameState currentState;
    private InputManager inputManager;
    private boolean done;

    public GameStateManager(InputManager inputManager,
        Image defaultImage)
    {
        this.inputManager = inputManager;
        this.defaultImage = defaultImage;
        gameStates = new HashMap();
    }

    public void addState(GameState state) {
        gameStates.put(state.getName(), state);
    }

    public Iterator getStates() {
        return gameStates.values().iterator();
    }

    public void loadAllResources(ResourceManager resourceManager) {
        Iterator i = getStates();
        while (i.hasNext()) {
            GameState gameState = (GameState)i.next();
            gameState.loadResources(resourceManager);
        }
    }


    public boolean isDone() {
        return done;
    }


    /**
        Ustawia biecy stan (definiowany za pomoc nazwy).
    */
    public void setState(String name) {
        // czyci poprzedni stan
        if (currentState != null) {
            currentState.stop();
        }
        inputManager.clearAllMaps();

        if (name == EXIT_GAME) {
            done = true;
        }
        else {

            // ustawia nowy stan
            currentState = (GameState)gameStates.get(name);
            if (currentState != null) {
                currentState.start(inputManager);
            }
        }
    }


    /**
        Aktualizuje wiat, obsuguje urzdzenia wejciowe.
    */
    public void update(long elapsedTime) {
        // jeli brak stanu, wprowad krtk pauz
        if (currentState == null) {
            try {
                Thread.sleep(100);
            }
            catch (InterruptedException ex) { }
        }
        else {
            String nextState = currentState.checkForStateChange();
            if (nextState != null) {
                setState(nextState);
            }
            else {
                currentState.update(elapsedTime);
            }
        }
    }


    /**
        Rysuje obraz na ekranie.
    */
    public void draw(Graphics2D g) {
        if (currentState != null) {
            currentState.draw(g);
        }
        else {
            // jeli brak stanu, narysuj na ekranie obraz domylny
            g.drawImage(defaultImage, 0, 0, null);
        }
    }

}