package com.brackeen.javagamebook.state;

import java.awt.Graphics2D;
import com.brackeen.javagamebook.input.InputManager;

public interface GameState {


    /**
        Zwraca nazw tego stanu. Metoda jest wykorzystywana przez
        metod checkForStateChange().
    */
    public String getName();


    /**
        Zwraca nazw kolejnego stanu, jeli biecy stan jest gotowy
        do przejcia do innego stanu; w przeciwnym przypadku metoda
        zwraca null.
    */
    public String checkForStateChange();


    /**
        Wczytuje wszystkie zasoby dla tego stanu. Ta metoda jest
        wywoywana w wtku dziaajcym w tle, zanim zostanie ustawiony
        jakikolwiek obiekt klasy GameState.
    */
    public void loadResources(ResourceManager resourceManager);

    /**
        Inicjalizuje ten stan i ustawia menadera sygnaw wejciowych
    */
    public void start(InputManager inputManager);


    /**
        Wykonuje wszystkie czynnoci potrzebne do zatrzymania tego stanu.
    */
    public void stop();


    /**
        Aktualizuje wiat, obsuguje sygnay z urzdze wejciowych.
    */
    public void update(long elapsedTime);


    /**
        Rysuje obraz na ekranie.
    */
    public void draw(Graphics2D g);
}

