
import java.awt.*;
import com.brackeen.javagamebook.graphics.*;
import com.brackeen.javagamebook.test.GameCore;


public class ImageFontTest extends GameCore {

    public static void main(String[] args) {
        new ImageFontTest().run();
    }

    private static final long TOTAL_TIME = 6500;

    private ImageFont bigFont;
    private ImageFont medFont;
    private long remainingTime;
    private CharMovement[] charMovement;

    public void init() {
        super.init();

        remainingTime = TOTAL_TIME;
        // wczytuje obrazy czcionki
        bigFont = new ImageFont("../fonts/big");
        medFont = new ImageFont("../fonts/medium");

        String message = "Pozdrowienia!";
        int stringWidth = medFont.stringWidth(message);
        charMovement = new CharMovement[message.length()];
        for (int i=0; i<message.length(); i++) {
            charMovement[i] = new CharMovement(message, i,
                (screen.getWidth() - stringWidth) / 2,
                screen.getHeight() / 2);
        }
    }

    public void update(long elapsedTime) {
        remainingTime -= elapsedTime;
        if (remainingTime <= 0) {
            stop();
        }
    }

    public void draw(Graphics2D g) {
        // czyci to
        g.setColor(Color.BLACK);
        g.fillRect(0,0,screen.getWidth(), screen.getHeight());

        // wywietla tekst
        medFont.drawString(g, "Lewy", 0, 0,
            ImageFont.LEFT | ImageFont.TOP);
        medFont.drawString(g, "Centrum", screen.getWidth()/2, 0,
            ImageFont.HCENTER | ImageFont.TOP);
        medFont.drawString(g, "Prawy", screen.getWidth(), 0,
            ImageFont.RIGHT | ImageFont.TOP);

        // wywietla pozostae sekundy
        String timeLeft = "" + (remainingTime / 1000);
        bigFont.drawString(g, timeLeft, 0, screen.getHeight());

        // wywietla poruszajce si znaki
        double p = (double)(TOTAL_TIME - remainingTime) / TOTAL_TIME;
        for (int i=0; i<charMovement.length; i++) {
            charMovement[i].draw(g, p);
        }
    }

    /**
        Prosta klasa odpowiedzialna za ruch znaku po okrelonej ciece.
    */
    public class CharMovement {
        char ch;
        Point[] path;

        public CharMovement(String s, int charIndex, int x, int y) {
            int stringWidth = medFont.stringWidth(s);
            for (int i=0; i<charIndex; i++) {
                x+=medFont.charWidth(s.charAt(i));
            }
            ch = s.charAt(charIndex);

            path = new Point[4];

            // rozpocznij poza ekranem
            path[0] = new Point(x-2000, y);

            // przesu znak na rodek ekranu i tam go zatrzymaj
            path[1] = new Point(x, y);
            path[2] = path[1];

            // "wysad" znak i rozrzu jego czci w losowych kierunkach
            double angle = Math.random() * 2 * Math.PI;
            double distance = 1000 + 1000*Math.random();
            path[3] = new Point(
                (int)Math.round(x + Math.cos(angle) * distance),
                (int)Math.round(y + Math.sin(angle) * distance));
        }

        /**
            Rysuje ten znak na jego ciece; p reprezentuje pooenie
            na ciece i moe mie warto od 0 do 1.
        */
        public void draw(Graphics g, double p) {
            int points = path.length - 1;
            int index = (int)(p*points);
            p = p * points - index;
            Point start = path[index % path.length];
            Point goal = path[(index + 1) % path.length];
            int x = (int)Math.round(goal.x * p + start.x * (1-p));
            int y = (int)Math.round(goal.y * p + start.y * (1-p));
            medFont.drawChar(g, ch, x, y);
        }
    }
}
