package com.brackeen.javagamebook.scripting;

/**
    Zadanie gry, ktre moe by planowane do jednokrotnego wykonania.
*/
public class GameTask implements Runnable {

    private long remainingTime;
    private Runnable runnable;
    private boolean done;

    /**
        Tworzy nowy obiekt GameTask ktry bdzie wykonywa podany obiekt
        Runnable po zadanym czasie.
    */
    public GameTask(long delay, Runnable runnable) {
        this.remainingTime = delay;
        this.runnable = runnable;
    }

    /**
        Anuluje to zadanie.
    */
    public void cancel() {
        done = true;
    }

    /**
        Uruchamia to zadanie.
    */
    public void run() {
        if (runnable != null) {
            runnable.run();
        }
    }

    /**
        Sprawdza, czy obiekt GameTask jest gotowy do uruchomienia
        i jeeli tak, jest uruchamiany. Zwraca true, jeeli zadanie jest 
        zakoczone (niezalenie, czy jest wykonane czy wczeniej anulowane).
    */
    public boolean check(long elapsedTime) {
        if (!done) {
            remainingTime-=elapsedTime;
            if (remainingTime <= 0) {
                done = true;
                try {
                    run();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        return done;
    }

}