package com.brackeen.javagamebook.scripting;

import java.util.EventListener;
import com.brackeen.javagamebook.game.GameObject;

/**
    Interfejs do odbierania powiadomie o zdarzeniach GameObject.
    Patrz GameObject.addListener().
*/
public interface GameObjectEventListener extends EventListener {

    /**
        Powiadamia GameObject czy by widoczny podczas ostatniej aktualizacji.
    */
    public void notifyVisible(GameObject object, boolean visible);


    /**
        Powiadamia GameObject gdy jest przesunity, lub koliduje
        z innym obiektem.
    */
    public void notifyObjectCollision(GameObject object,
        GameObject otherObject);


    /**
        Powiadamia GameObject o dotkniciu podanego obiektu.
        Metoda ta nie jest wywoywana jeeli te dwa obiekty
        dotykay si w poprzedniej ramce.
    */
    public void notifyObjectTouch(GameObject object,
        GameObject otherObject);


    /**
        Powiadamia GameObject o zakczeniu dotykania z podanym obiektem.
    */
    public void notifyObjectRelease(GameObject object,
        GameObject otherObject);


    /**
        Powiadamia GameObject e w czasie ruchu koliduje z podog.
    */
    public void notifyFloorCollision(GameObject object);


    /**
        Powiadamia GameObject e w czasie ruchu koliduje z sufitem.
    */
    public void notifyCeilingCollision(GameObject object);


    /**
        Powiadamia GameObject e w czasie ruchu koliduje ze cian.
    */
    public void notifyWallCollision(GameObject object);



}