package com.brackeen.javagamebook.ai.pattern;

import java.util.*;
import com.brackeen.javagamebook.game.GameObject;
import com.brackeen.javagamebook.math3D.Vector3D;
import com.brackeen.javagamebook.bsp2D.BSPTree;
import com.brackeen.javagamebook.util.MoreMath;

/**
    Wzorzec uniku "dodge" polegajcego na bieganiu zygzakiem
    w pewnej odlegoci od gracza.
*/
public class DodgePatternZigZag extends AIPattern {

    private float dodgeDist;

    public DodgePatternZigZag(BSPTree tree) {
        this(tree, 200);
    }

    public DodgePatternZigZag(BSPTree tree, float dodgeDist) {
        super(tree);
        this.dodgeDist = dodgeDist;
    }


    public Iterator find(GameObject bot, GameObject player) {

        // stwrz wektor prowadzcy do punktu uniku
        Vector3D zig = new Vector3D(bot.getLocation());
        zig.subtract(player.getLocation());
        zig.normalize();
        zig.multiply(dodgeDist);
        zig.rotateY((float)Math.PI/2);

        // 50% szans  unik w jedn lub w drug stron
        if (MoreMath.chance(.5f)) {
            zig.multiply(-1);
        }

        // przeksztaca wektor na wsprzdne bezwzgldne
        zig.add(bot.getLocation());
        calcFloorHeight(zig, bot.getFloorHeight());

        Vector3D zag = new Vector3D(bot.getLocation());
        calcFloorHeight(zag, bot.getFloorHeight());

        List path = new ArrayList();
        path.add(zig);
        path.add(zag);

        return path.iterator();
    }

}

