package com.brackeen.javagamebook.bsp2D;

import com.brackeen.javagamebook.math3D.*;

/**
    Klasa BSPPolygon jest rozszerzeniem klasy TexturedPolygon3D
    z dodatkowymi staymi typu (TYPE_FLOOR, TYPE_WALL lub 
    TYPE_PASSABLE_WALL), wartoci intensywnoci wiata
    otoczenia i obiektem klasy BSPLine (jeli typem ciany jest
    TYPE_WALL lub TYPE_PASSABLE_WALL).
*/
public class BSPPolygon extends TexturedPolygon3D {

    public static final int TYPE_FLOOR = 0;
    public static final int TYPE_WALL = 1;
    public static final int TYPE_PASSABLE_WALL = 2;

    /**
        Definiuje odlego, w jakiej musi si znajdowa ciana, by
        potwry i gracze mogli j przekracza.
    */
    public static final int PASSABLE_WALL_THRESHOLD = 32;

    /**
        Definiuje wysoko przejcia, ktra umoliwia potwrom i graczom
        jego pokonywanie.
    */
    public static final int PASSABLE_ENTRYWAY_THRESHOLD = 128;


    private int type;
    private float ambientLightIntensity;
    private BSPLine line;

    /**
        Tworzy nowy obiekt BSPPolygon dla przekazanych wierzchokw
        i typu (TYPE_FLOOR, TYPE_WALL lub TYPE_PASSABLE_WALL).
    */
    public BSPPolygon(Vector3D[] vertices, int type) {
        super(vertices);
        this.type = type;
        ambientLightIntensity = 0.5f;
        if (isWall()) {
            line = new BSPLine(this);
        }
    }


    /**
        Powiela ten wielokt, jednak z innym zbiorem wierzchokw.
    */
    public BSPPolygon clone(Vector3D[] vertices) {
        BSPPolygon clone = new BSPPolygon(vertices, type);
        clone.setNormal(getNormal());
        clone.setAmbientLightIntensity(getAmbientLightIntensity());
        if (getTexture() != null) {
            clone.setTexture(getTexture(), getTextureBounds());
        }
        return clone;
    }


    /**
        Zwraca true, jeli ten obiekt BSPPolygon reprezentuje cian.
    */
    public boolean isWall() {
        return (type == TYPE_WALL) || (type == TYPE_PASSABLE_WALL);
    }


    /**
        Zwraca true, jeli ten obiekt BSPPolygon reprezentuje cian
        uniemoliwiajc przejcie.
    */
    public boolean isSolidWall() {
        return type == TYPE_WALL;
    }


    /**
        Zwraca lini reprezentujc ten obiekt BSPPolygon. Zwraca null,
        jeli ten obiekt BSPPolygon nie jest cian.
    */
    public BSPLine getLine() {
        return line;
    }


    public void setAmbientLightIntensity(float a) {
        ambientLightIntensity = a;
    }


    public float getAmbientLightIntensity() {
        return ambientLightIntensity;
    }

}
