package com.brackeen.javagamebook.graphics3D;

/**
    Klasa ZBuffer implementuje z-bufor, czyli bufor gbi, w ktrym s
    przechowywane gbokoci wszystkich pikseli obiektw trjwymiarowych
    wywietlanych na ekranie. Warto zapisana dla kadego piksela jest
    odwrotnoci jego gbokoci (1/z), zatem dla obiektw znajdujcych
    si bliej pierwszego planu precyzja jest wiksza ni w przypadku 
    obiektw znajdujcych si dalej od kamery (gdzie dua precyzja 
    gbokoci jest mniej nieistotna z punktu widzenia jakoci obrazu).
*/
public class ZBuffer {

    private short[] depthBuffer;
    private int width;
    private int height;

    /**
        Tworzy nowy z-bufor o okrelonej szerokoci i wysokoci.
    */
    public ZBuffer(int width, int height) {
        depthBuffer = new short[width*height];
        this.width = width;
        this.height = height;
        clear();
    }


    /**
        Zwraca szeroko tego z-bufora.
    */
    public int getWidth() {
        return width;
    }


    /**
        Zwraca wysoko tego z-bufora.
    */
    public int getHeight() {
        return height;
    }


    /**
        Zwraca tablic uywan do przechowywania tego bufora gbi.
    */
    public short[] getArray() {
        return depthBuffer;
    }


    /**
        Czyci z-bufor. Wszystkie gbokoci bd miay warto 0.
    */
    public void clear() {
        for (int i=0; i<depthBuffer.length; i++) {
            depthBuffer[i] = 0;
        }
    }


    /**
        Ustawia gboko dla piksela w danej pozycji,
        zastpuje dotychczasow warto w buforze.
    */
    public void setDepth(int offset, short depth) {
        depthBuffer[offset] = depth;
    }


    /**
        Sprawdza gboko piksela w danej pozycji, jeli przekazana
        gboko jest mniejsza (przekazana warto jest wiksza lub
        rwna wartoci przechowywanej w z-buforze na danej pozycji),
        wwczas w buforze jest zapisywana nowa gboko, a metoda
        zwraca warto true. W przeciwnym przypadku w buforze nie s
        wprowadzane adne zmiany a metoda zwraca warto false.
    */
    public boolean checkDepth(int offset, short depth) {
        if (depth >= depthBuffer[offset]) {
            depthBuffer[offset] = depth;
            return true;
        }
        else {
            return false;
        }
    }

}
