package com.brackeen.javagamebook.sound;

/**
    Klasa abstrakcyjna, zaprojektowana do filtrowania prbek dwikowych.
    Poniewa obiekty SoundFilter mog korzysta z wewntrznego buforowania
    prbek, dla kadego odtwarzanego dwiku naley tworzy osobny obiekt
    SoundFilter. Po zakoczeniu odtwarzania dwiku obiekty
    SoundFilters mog by ponownie wykorzystane po wywoaniu metody reset().
    <p>Zakadamy, e prbki s w formacie 16-bitowym, ze znakiem i z rosncym
    porzdkiem bitw.
    @see FilteredSoundStream
*/
public abstract class SoundFilter{

    /**
        Resetuje biecy SoundFilter. Domylnie nie wykonuje adnych operacji.
    */
    public void reset() {
        // Nie wykonuj adnych operacji.
    }

    /**
        Zwraca ilo dodatkowych danych (w bajtach), ktre filtr 
        odtwarza po zakoczeniu oryginalnego dwiku. Przykadem 
        moe by echo, ktre trwa duej ni oryginalny dwik.
        Domylnie metoda zwraca 0.
    */
    public int getRemainingSize() {
        return 0;
    }

    /**
        Filtruje tablic prbek. Prbki powinny by w formacie 
        16-bitowym, ze znakiem i z rosncym porzdkiem bitw.
    */
    public void filter(byte[] samples) {
        filter(samples, 0, samples.length);
    }

    /**
        Filtruje tablic prbek. Prbki powinny by w formacie 16-bitowym, 
        ze znakiem i z rosncym porzdkiem bitw. Metoda ta powinna
        by zaimplementowana w klasach pochodnych.
    */
    public abstract void filter(
        byte[] samples, int offset, int length);


    /**
        Wygodna metoda do pobierania 16-bitowych prbek z tablicy bajtw.
        Prbki powinny by w formacie 16-bitowym, ze znakiem
        i z rosncym porzdkiem bitw.
    */
    public static short getSample(byte[] buffer, int position) {
        return (short)(
            ((buffer[position+1] & 0xff) << 8) |
            (buffer[position] & 0xff));
    }


    /**
        Wygodna metoda do ustawiania 16-bitowych prbek w tablicy bajtw.
        Prbki powinny by w formacie 16-bitowym, ze znakiem 
        i z rosncym porzdkiem bitw.
    */
    public static void setSample(byte[] buffer, int position,
        short sample)
    {
        buffer[position] = (byte)(sample & 0xff);
        buffer[position+1] = (byte)((sample >> 8) & 0xff);
    }

}
