import java.io.*;

import com.brackeen.javagamebook.sound.*;

/**
    Przykad odtwarzania dwiku z filtrem echa.
    @see EchoFilter
    @see SimpleSoundPlayer
*/
public class EchoFilterTest {

    public static void main(String[] args) {

        // adowanie dwiku.
        SimpleSoundPlayer sound =
            new SimpleSoundPlayer("../sounds/voice.wav");

        // Tworzenie strumienia dwikowego.
        InputStream is =
            new ByteArrayInputStream(sound.getSamples());

        // Tworzenie echa z buforem na 11025 prbek
        // (1/4 sekundy dla dwiku 44100 Hz) oraz 60% wytumieniem.
        EchoFilter filter = new EchoFilter(11025, .6f);

        // Tworzenie filtrowanego strumienia dwikowego.
        is = new FilteredSoundStream(is, filter);

        // Odtwarzanie dwiku.
        sound.play(is);

        // Z powodu bdu w Java Sound jawnie zakocz prac VM.
        System.exit(0);
    }
}
