package com.brackeen.javagamebook.graphics;

import javax.swing.RepaintManager;
import javax.swing.JComponent;

/**
    Klasa NullRepaintManager dziedziczy po RepaintManager 
    i nie wykonuje adnych operacji. Jest przydatna 
    w przypadku aplikacji samodzielnie obsugujcych renderowanie.
*/
public class NullRepaintManager extends RepaintManager {

    /**
        Instaluje NullRepaintManager.
    */
    public static void install() {
        RepaintManager repaintManager = new NullRepaintManager();
        repaintManager.setDoubleBufferingEnabled(false);
        RepaintManager.setCurrentManager(repaintManager);
    }

    public void addInvalidComponent(JComponent c) {
        // Nie wykonuj adnych operacji.
    }

    public void addDirtyRegion(JComponent c, int x, int y,
        int w, int h)
    {
        // Nie wykonuj adnych operacji.
    }

    public void markCompletelyDirty(JComponent c) {
        // Nie wykonuj adnych operacji.
    }

    public void paintDirtyRegions() {
        // Nie wykonuj adnych operacji.
    }
}
