public class ThreadPoolTest {

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Test zada ThreadPool.");
            System.out.println(
                "Uzycie: java ThreadPoolTest liczbaZada liczbaWatkw");
            System.out.println(
                "  iloZada - liczba: liczba zada do wykonania.");
            System.out.println(
                "  iloWtkw - liczba: liczba wtkw " +
                "w puli.");
            return;
        }
        int numTasks = Integer.parseInt(args[0]);
        int numThreads = Integer.parseInt(args[1]);

        // Utworzenie puli wtkw:
        ThreadPool threadPool = new ThreadPool(numThreads);

        // Uruchomienie przykadowych wtkw:
        for (int i=0; i<numTasks; i++) {
            threadPool.runTask(createTask(i));
        }

        // Zamknicie puli i oczekiwanie na zakoczenie wszystkich zada.
        threadPool.join();
    }


    /**
        Tworzy prosty obiekt Runnable drukujcy ID i oczekujcy 500
        milisekund; nastpnie ponownie drukowany jest identyfikator zadania.
    */
    private static Runnable createTask(final int taskID) {
        return new Runnable() {
            public void run() {
                System.out.println("Zadanie " + taskID + ": uruchomione");

                // Symulowanie dugo dziaajcego zadania:
                try {
                    Thread.sleep(500);
                }
                catch (InterruptedException ex) { }

                System.out.println("Zadanie " + taskID + ": koniec");
            }
        };
    }
}
