package com.brackeen.javagamebook.sound;

import com.brackeen.javagamebook.graphics.Sprite;

/**
    Klasa Filter3d dziedziczy po SoundFilter i realizuje efekt
    dwiku 3d. Dwik jest filtrowany w taki sposb, e
    cichnie wraz ze wzrostem odlegoci od suchacza.
    <p>Moliwe rozszerzenia tej klasy:
    <ul><li>przesuwanie dwiku midzy lewym i prawym gonikiem
    </ul>
    @see FilteredSoundStream
*/
public class Filter3d extends SoundFilter {

    // ilo prbek do przesunicia podczas zmiany gonoci.
    private static final int NUM_SHIFTING_SAMPLES = 500;

    private Sprite source;
    private Sprite listener;
    private int maxDistance;
    private float lastVolume;

    /**
        Tworzy nowy obiekt Filter3d z podanym duszkiem rda i suchacza
        Zmiana pooenia duszka moe by zmieniana w czasie dziaania
        filtra.
        <p> Parametr maxDistance jest maksymaln odlegoci z ktrej
        jest syszalny dwik.
    */
    public Filter3d(Sprite source, Sprite listener,
        int maxDistance)
    {
        this.source = source;
        this.listener = listener;
        this.maxDistance = maxDistance;
        this.lastVolume = 0.0f;
    }

    /**
        Filtruje dwik w taki sposb, e jest cichszy z wikszej odlegoci.
    */
    public void filter(byte[] samples, int offset, int length) {

        if (source == null || listener == null) {
            // brak danych do filtrowania - koniec
            return;
        }

        // obliczenie odlegoci suchacza od rda dwiku
        float dx = (source.getX() - listener.getX());
        float dy = (source.getY() - listener.getY());
        float distance = (float)Math.sqrt(dx * dx + dy * dy);

        // ustawienie gonoci od 0 (cisza) do 1
        float newVolume = (maxDistance - distance) / maxDistance;
        if (newVolume <= 0) {
            newVolume = 0;
        }

        // ustawienie gonoci prbek
        int shift = 0;
        for (int i=offset; i<offset+length; i+=2) {

            float volume = newVolume;

            // przesunicie od ostatniej gonoci do nowej
            if (shift < NUM_SHIFTING_SAMPLES) {
                volume = lastVolume + (newVolume - lastVolume) *
                    shift / NUM_SHIFTING_SAMPLES;
                shift++;
            }

            // zmiana gonoci prbki
            short oldSample = getSample(samples, i);
            short newSample = (short)(oldSample * volume);
            setSample(samples, i, newSample);
        }

        lastVolume = newVolume;
    }
}
