package com.brackeen.javagamebook.tilegame;

import java.awt.Image;
import java.util.LinkedList;
import java.util.Iterator;

import com.brackeen.javagamebook.graphics.Sprite;

/**
    Klasa TileMap zawiera dane mapy korzystjcej z kafelkw
    i zawierajcej duszki. Kady kafelek jest odwoaniem do obiektu
    Image. Oczywicie obiekty Image s wykorzystywane wielokrotnie.
*/
public class TileMap {

    private Image[][] tiles;
    private LinkedList sprites;
    private Sprite player;

    /**
        Tworzenie nowego obiektu TileMap o okrelonej szerokoci
        i wysokoci (wyraonej liczb kafelkw) mapy.
    */
    public TileMap(int width, int height) {
        tiles = new Image[width][height];
        sprites = new LinkedList();
    }

    /**
        Zwraca szeroko biecego obiektu TileMap (ilo kafelkw w poziomie).
    */
    public int getWidth() {
        return tiles.length;
    }

    /**
        Zwraca wysoko biecego obiektu TileMap (ilo kafelkw w pionie).
    */
    public int getHeight() {
        return tiles[0].length;
    }

    /**
        Zwraca kafelek o okrelonych wsprzdnych. Zwraca null jeeli
        w tych wsprzdnych nie ma kafelka lub wsprzdne s poza zakresem.
    */
    public Image getTile(int x, int y) {
        if (x < 0 || x >= getWidth() ||
            y < 0 || y >= getHeight())
        {
            return null;
        }
        else {
            return tiles[x][y];
        }
    }

    /**
        Ustawia kafelek na okrelonych wsprzdnych
    */
    public void setTile(int x, int y, Image tile) {
        tiles[x][y] = tile;
    }

    /**
        Zwraca duszka bohatera.
    */
    public Sprite getPlayer() {
        return player;
    }

    /**
        Ustawia duszka bohatera.
    */
    public void setPlayer(Sprite player) {
        this.player = player;
    }

    /**
        Dodaje obiekt Sprite do mapy.
    */
    public void addSprite(Sprite sprite) {
        sprites.add(sprite);
    }

    /**
        Usuwa obiekt Sprite z mapy.
    */
    public void removeSprite(Sprite sprite) {
        sprites.remove(sprite);
    }

    /**
        Zwraca obiekt Iterator dla wszystkich duszkw tej mapy,
        poza duszkiem bohatera.
    */
    public Iterator getSprites() {
        return sprites.iterator();
    }
}
