import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.brackeen.javagamebook.graphics.*;
import com.brackeen.javagamebook.input.GameAction;

/**
    Rozszerza InputManagerTest o przyciski Swing, pozwalajce
    wczy pauz, uruchomi konfiguracj i zakoczy program.
*/
public class MenuTest extends InputManagerTest
    implements ActionListener
{

    public static void main(String[] args) {
        new MenuTest().run();
    }

    protected GameAction configAction;

    private JButton playButton;
    private JButton configButton;
    private JButton quitButton;
    private JButton pauseButton;
    private JPanel playButtonSpace;

    public void init() {
        super.init();
        // Upewnij si, e komponenty Swing nie odrysuj si samodzielnie.
        NullRepaintManager.install();

        // Tworzenie dodatkowego obiektu GameAction dla konfiguracji.
        configAction = new GameAction("config");

        // Tworzenie przyciskw:
        quitButton = createButton("quit", "Koniec");
        playButton = createButton("play", "Kontynuuj");
        pauseButton = createButton("pause", "Pauza");
        configButton = createButton("config", "Zmiana ustawie");

        // Tworzenie miejsca na przyciski Pauza i Kontynuuj.
        playButtonSpace = new JPanel();
        playButtonSpace.setOpaque(false);
        playButtonSpace.add(pauseButton);

        JFrame frame = super.screen.getFullScreenWindow();
        Container contentPane = frame.getContentPane();

        // Upewnij si, e panel jest przezroczysty:
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).setOpaque(false);
        }

        // Dodaj komponenty do panelu:
        contentPane.setLayout(new FlowLayout(FlowLayout.LEFT));
        contentPane.add(playButtonSpace);
        contentPane.add(configButton);
        contentPane.add(quitButton);

        // Jawne uoenie komponentw (wymagane w niektrych systemach).
        frame.validate();
    }

    /**
        Rozszerza InputManagerTest o rysowanie komponentw Swing.
    */
    public void draw(Graphics2D g) {
        super.draw(g);
        JFrame frame = super.screen.getFullScreenWindow();

        // Panel warstwowy zawiera takie elementy, jak "wyskakujce"
        // okna podpowiedzi, menu oraz panel zawartoci.
        frame.getLayeredPane().paintComponents(g);
    }


    /**
        Zmienia przycisk Pauza/Kontynuuj po przeczeniu pauzy.
    */
    public void setPaused(boolean p) {
        super.setPaused(p);
        playButtonSpace.removeAll();
        if (isPaused()) {
            playButtonSpace.add(playButton);
        }
        else {
            playButtonSpace.add(pauseButton);
        }
    }

    /**
        Wywoywany przez wtek rozdzielajcy 
        zdarzenia AWT po naciniciu klawisza.
    */
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == quitButton) {
            // Wywoaj akcj "exit".
            super.exit.tap();
        }
        else if (src == configButton) {
            // Nie wykonuj adnych operacji (na razie).
            configAction.tap();
        }
        else if (src == playButton || src == pauseButton) {
            // Wywoaj akcj "pause".
            super.pause.tap();
        }
    }


    /**
        Tworzy JButton Swing. Rysunek wykorzystywany do utworzenia przycisku 
        nosi nazw "../images/menu/" + nazwa + ".png". Rysunek jest modyfikowany
        w celu uzyskania wygldu "domylnego" (przewiecajcy)
        oraz "przycinitego" (przesunity w d i w prawo).
        <p>Przycisk nie ma wygldu zwykego przycisku Swing
        - zamiast tego wykorzystany jest rysunek.
    */
    public JButton createButton(String name, String toolTip) {

        // adowanie rysunku:
        String imagePath = "../images/menu/" + name + ".png";
        ImageIcon iconRollover = new ImageIcon(imagePath);
        int w = iconRollover.getIconWidth();
        int h = iconRollover.getIconHeight();

        // Pobranie kursora dla tego przycisku:
        Cursor cursor =
            Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);

        // Tworzenie domylnego, przewiecajcego przycisku:
        Image image = screen.createCompatibleImage(w, h,
            Transparency.TRANSLUCENT);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Composite alpha = AlphaComposite.getInstance(
            AlphaComposite.SRC_OVER, .5f);
        g.setComposite(alpha);
        g.drawImage(iconRollover.getImage(), 0, 0, null);
        g.dispose();
        ImageIcon iconDefault = new ImageIcon(image);

        // Tworzenie przycisku przycinitego:
        image = screen.createCompatibleImage(w, h,
            Transparency.TRANSLUCENT);
        g = (Graphics2D)image.getGraphics();
        g.drawImage(iconRollover.getImage(), 2, 2, null);
        g.dispose();
        ImageIcon iconPressed = new ImageIcon(image);

        // Tworzenie przycisku:
        JButton button = new JButton();
        button.addActionListener(this);
        button.setIgnoreRepaint(true);
        button.setFocusable(false);
        button.setToolTipText(toolTip);
        button.setBorder(null);
        button.setContentAreaFilled(false);
        button.setCursor(cursor);
        button.setIcon(iconDefault);
        button.setRolloverIcon(iconRollover);
        button.setPressedIcon(iconPressed);

        return button;
    }
}
