package com.brackeen.javagamebook.tilegame.sprites;

import java.lang.reflect.Constructor;
import com.brackeen.javagamebook.graphics.*;

/**
    Klasa PowerUp dziedziczy po Sprite. Bohater moe podnosi ten obiekt.
*/
public abstract class PowerUp extends Sprite {

    public PowerUp(Animation anim) {
        super(anim);
    }

    public Object clone() {
        // wykorzystanie refleksji do utworzenia obiektu waciwej podklasy
        Constructor constructor = getClass().getConstructors()[0];
        try {
            return constructor.newInstance(
                new Object[] {(Animation)anim.clone()});
        }
        catch (Exception ex) {
            // nie powinno si nigdy wykona
            ex.printStackTrace();
            return null;
        }
    }

    /**
        Klasa Star dziedziczca po PowerUp. Daje bohaterowi punkty.
    */
    public static class Star extends PowerUp {
        public Star(Animation anim) {
            super(anim);
        }
    }

    /**
        Klasa Music dziedziczca po PowerUp. Zmienia muzyk w grze.
    */
    public static class Music extends PowerUp {
        public Music(Animation anim) {
            super(anim);
        }
    }

    /**
        Klasa Goal dziedziczca po PowerUp. Przejcie do nastpnej mapy.
    */
    public static class Goal extends PowerUp {
        public Goal(Animation anim) {
            super(anim);
        }
    }
}
