package com.brackeen.javagamebook.shooter3D;

import com.brackeen.javagamebook.math3D.*;
import com.brackeen.javagamebook.game.*;
import com.brackeen.javagamebook.ai.Projectile;

/**
    Obiekt gracza.
*/
public class Player extends JumpingGameObject {

    private static final float BULLET_HEIGHT = 75;
    private static final float DEFAULT_PLAYER_RADIUS = 32;
    private static final float DEFAULT_PLAYER_HEIGHT = 128;
    private static final float DEFAULT_MAX_HEALTH = 100;

    private PolygonGroup blastModel;
    private float maxHealth;
    private float health;

    public Player() {
        super(new PolygonGroup("Player"));

        // ustawia otoczenie gracza
        PolygonGroupBounds playerBounds = getBounds();
        playerBounds.setTopHeight(DEFAULT_PLAYER_HEIGHT);
        playerBounds.setRadius(DEFAULT_PLAYER_RADIUS);

        // ustawia poziom zdrowia
        maxHealth = DEFAULT_MAX_HEALTH;
        setHealth(maxHealth);
    }

    public void setBlastModel(PolygonGroup blastModel) {
        this.blastModel = blastModel;
    }

    public float getHealth() {
        return health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public float getMaxHealth() {
        return maxHealth;
    }

    public void addHealth(float addition) {
        setHealth(health + addition);
    }

    public boolean isAlive() {
        return (health > 0);
    }

    public void fireProjectile() {

        float x = -getTransform().getSinAngleY();
        float z = -getTransform().getCosAngleY();
        float cosX = getTransform().getCosAngleX();
        float sinX = getTransform().getSinAngleX();
        Projectile blast = new Projectile(
            (PolygonGroup)blastModel.clone(),
            new Vector3D(cosX*x, sinX, cosX*z),
            null,
            40, 60);
        float dist = getBounds().getRadius() +
            blast.getBounds().getRadius();
        blast.getLocation().setTo(
            getX() + x*dist,
            getY() + BULLET_HEIGHT,
            getZ() + z*dist);

        // tworzy nowy obiekt w grze
        addSpawn(blast);

        // powoduje "wirtualny" haas, ktry moe by "usyszany" przez boty
        // (przez 500 milisekund)
        makeNoise(500);
    }

}
