package com.brackeen.javagamebook.graphics3D;

import java.awt.Graphics2D;
import java.awt.Color;
import com.brackeen.javagamebook.math3D.*;

/**
    Klasa SolidPolygonRenderer transformuje i rzutuje na ekran
    wielokt wypeniony jednolitym kolorem.
*/
public class SolidPolygonRenderer extends PolygonRenderer {

    public SolidPolygonRenderer(Transform3D camera,
        ViewWindow viewWindow)
    {
        this(camera, viewWindow, true);
    }

    public SolidPolygonRenderer(Transform3D camera,
        ViewWindow viewWindow, boolean clearViewEveryFrame)
    {
        super(camera, viewWindow, clearViewEveryFrame);
    }


    /**
        Rzutuje biecy wielokt. W tym momencie biecy wielokt         
        jest transformowany, przycinany, rzutowany, konwertowany
        na skany i rysowany.
    */

    protected void drawCurrentPolygon(Graphics2D g) {

        // ustaw kolor
        if (sourcePolygon instanceof SolidPolygon3D) {
            g.setColor(((SolidPolygon3D)sourcePolygon).getColor());
        }
        else {
            g.setColor(Color.GREEN);
        }

        // rysuj linie skanw
        int y = scanConverter.getTopBoundary();
        while (y<=scanConverter.getBottomBoundary()) {
            ScanConverter.Scan scan = scanConverter.getScan(y);
            if (scan.isValid()) {
                g.drawLine(scan.left, y, scan.right, y);
            }
            y++;
        }
    }
}
