package com.brackeen.javagamebook.ai.pattern;

import java.util.Iterator;
import java.util.Collections;
import com.brackeen.javagamebook.game.GameObject;
import com.brackeen.javagamebook.math3D.Vector3D;
import com.brackeen.javagamebook.bsp2D.BSPTree;

/**
    Bezporednie celowanie w gracza. Wzorce celowania zwracaj
    kierunek strzeu, nie punkt, w ktry bot celuje.
*/
public class RunAwayPattern extends AIPattern {

    public RunAwayPattern(BSPTree tree) {
        super(tree);
    }

    public Iterator find(GameObject bot, GameObject player) {
        // gupi ruch: biegnij jak najdalej od gracza
        // (powoduje wbieganie botw w ciany!)

        Vector3D goal = new Vector3D(player.getLocation());
        goal.subtract(bot.getLocation());

        // przeciwny kierunek
        goal.multiply(-1);

        // jak najdalej
        goal.multiply(100000);
        calcFloorHeight(goal, bot.getFloorHeight());

        // zwraca iterator
        return Collections.singleton(goal).iterator();
    }

}

