package com.brackeen.javagamebook.sound;

/**
    Klasa FilterSequence dzidziczy po SoundFilter i pozwala na
    czenie ze sob kilku obiektw SoundFilters.
    <p>Klasa nie zostaa zamieszczona w ksiace.
    @see FilteredSoundStream
*/
public class FilterSequence extends SoundFilter {

    private SoundFilter[] filters;

    /**
        Tworzy nowy obiekt FilterSequence z podan tablic
        obiektw SoundFilter. Prbka jest przesyana kolejno
        przez wszystkie obiekty SoundFilter w kolejnoci zapisu 
        w tablicy.
    */
    public FilterSequence(SoundFilter[] filters) {
        this.filters = filters;
    }


    /**
        Zwraca maksymalny rozmiar pozostaycch danych we wszystkich obiektach SoundFilter
        w bieacym obiekcie FilterSequence.
    */
    public int getRemainingSize() {
        int max = 0;
        for (int i=0; i<filters.length; i++) {
            max = Math.max(max, filters[i].getRemainingSize());
        }
        return max;
    }

    /**
        Resetuje wszystkie obiekty SoundFilter w biecym FilterSequence.
    */
    public void reset() {
        for (int i=0; i<filters.length; i++) {
            filters[i].reset();
        }
    }


    /**
        Filtruje dwik przez kolejne obiekty SoundFilter z biecego
        FilterSequence.
    */
    public void filter(byte[] samples, int offset, int length) {
        for (int i=0; i<filters.length; i++) {
            filters[i].filter(samples, offset, length);
        }
    }
}
