import com.brackeen.javagamebook.graphics.*;

/**
    Klasa Player dziedziczy po klasie Sprite  dodawany jest w niej 
    stan obiektu (STATE_NORMAL lub STATE_JUMPING) oraz grawitacja.
*/
public class Player extends Sprite {

    public static final int STATE_NORMAL = 0;
    public static final int STATE_JUMPING = 1;

    public static final float SPEED = .3f;
    public static final float GRAVITY = .002f;

    private int floorY;
    private int state;

    public Player(Animation anim) {
        super(anim);
        state = STATE_NORMAL;
    }

    /**
        Odczytaj stan obiektu Player (ma warto STATE_NORMAL 
        lub STATE_JUMPING).
    */
    public int getState() {
        return state;
    }

    /**
        Ustaw stan obiektu Player (ma warto STATE_NORMAL 
        lub STATE_JUMPING).
    */
    public void setState(int state) {
        this.state = state;
    }

    /**
        Ustawia pooenie "podogi", gdzie gracz zaczyna i koczy skok.
    */
    public void setFloorY(int floorY) {
        this.floorY = floorY;
        setY(floorY);
    }

    /**
        Powoduje skok gracza.
    */
    public void jump() {
        setVelocityY(-1);
        state = STATE_JUMPING;
    }

    /**
        Aktualizuje pooenie i animacj gracza. Jeeli skaczcy gracz
        wylduje na pododze, jego stan jest zmieniany na NORMAL.
    */
    public void update(long elapsedTime) {
        // Ustawienie prdkoci w pionie (efekt grawitacji):
        if (getState() == STATE_JUMPING) {
            setVelocityY(getVelocityY() + GRAVITY * elapsedTime);
        }

        // Przesunicie gracza:
        super.update(elapsedTime);

        // Sprawdzenie, czy gracz wyldowa na "pododze":
        if (getState() == STATE_JUMPING && getY() >= floorY) {
            setVelocityY(0);
            setY(floorY);
            setState(STATE_NORMAL);
        }
    }
}
