import java.awt.*;
import java.awt.event.*;
import javax.swing.SwingUtilities;

import com.brackeen.javagamebook.graphics.*;
import com.brackeen.javagamebook.test.GameCore;

/**
    Prosty test rozgldania si za pomoc myszy. Uytkownik moe 
    przesuwa kursor myszy w kadym kierunku niemal bez ogranicze.
    Bez zastosowania tego efektu mysz zatrzymuje si na brzegu ekranu.
    <p>Mouselook korzysta z centrowania wskanika myszy po jej przesuniciu,
    dziki czemu mona obliczy wzgldne przesunicie myszy
    i wskanik nigdy nie zatrzyma si na brzegu ekranu. */
public class MouselookTest extends GameCore
    implements MouseMotionListener, KeyListener
{

    public static void main(String[] args) {
        new MouselookTest().run();
    }

    private Image bgImage;
    private Robot robot;
    private Point mouseLocation;
    private Point centerLocation;
    private Point imageLocation;
    private boolean relativeMouseMode;
    private boolean isRecentering;

    public void init() {
        super.init();
        mouseLocation = new Point();
        centerLocation = new Point();
        imageLocation = new Point();

        relativeMouseMode = true;
        isRecentering = false;

        try {
            robot = new Robot();
            recenterMouse();
            mouseLocation.x = centerLocation.x;
            mouseLocation.y = centerLocation.y;
        }
        catch (AWTException ex) {
            System.out.println("Nie mona utworzy obiektu Robot!");
        }
        Window window = screen.getFullScreenWindow();
        window.addMouseMotionListener(this);
        window.addKeyListener(this);
        bgImage = loadImage("../images/background.jpg");
    }

    public synchronized void draw(Graphics2D g) {

        int w = screen.getWidth();
        int h = screen.getHeight();

        // Upewnij si, e pooenie jest prawidowe:
        imageLocation.x %= w;
        imageLocation.y %= screen.getHeight();
        if (imageLocation.x < 0) {
            imageLocation.x += w;
        }
        if (imageLocation.y < 0) {
            imageLocation.y += screen.getHeight();
        }

        // Narysowanie rysunku w czterech miejscach, 
        // co powoduje pokrycie nim caego ekranu.
        int x = imageLocation.x;
        int y = imageLocation.y;
        g.drawImage(bgImage, x, y, null);
        g.drawImage(bgImage, x-w, y, null);
        g.drawImage(bgImage, x, y-h, null);
        g.drawImage(bgImage, x-w, y-h, null);

        // Ustawienia rysowania:
        g.setRenderingHint(
                RenderingHints.KEY_TEXT_ANTIALIASING,
                RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.drawString("Nacinij spacj, aby zmieni tryb myszy.", 5,
            FONT_SIZE);
        g.drawString("Nacinij Escape, aby zakoczy.", 5, FONT_SIZE*2);
    }

    /**
        Zastosowanie klasy Robot do ustawienia 
        wskanika myszy na rodku ekranu.
        <p>Naley pamita, e na niektrych platformach 
        funkcja ta jest niedostpna.
    */
    private synchronized void recenterMouse() {
        Window window = screen.getFullScreenWindow();
        if (robot != null && window.isShowing()) {
            centerLocation.x = window.getWidth() / 2;
            centerLocation.y = window.getHeight() / 2;
            SwingUtilities.convertPointToScreen(centerLocation,
                window);
            isRecentering = true;
            robot.mouseMove(centerLocation.x, centerLocation.y);
        }
    }

    // Z interfejsu MouseMotionListener:
    public void mouseDragged(MouseEvent e) {
        mouseMoved(e);
    }

    // Z interfejsu MouseMotionListener:
    public synchronized void mouseMoved(MouseEvent e) {
        // Jest to zdarzenie centrowania wskanika myszy  naley je zignorowa.
        if (isRecentering &&
            centerLocation.x == e.getX() &&
            centerLocation.y == e.getY())
        {
            isRecentering = false;
        }
        else {
            int dx = e.getX() - mouseLocation.x;
            int dy = e.getY() - mouseLocation.y;
            imageLocation.x += dx;
            imageLocation.y += dy;
            // Centrowanie wskanika myszy:
            if (relativeMouseMode) {
                recenterMouse();
            }
        }
        mouseLocation.x = e.getX();
        mouseLocation.y = e.getY();
    }

    // Z interfejsu KeyListener:
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            // Zakoczenie programu:
            stop();
        }
        else if (e.getKeyCode() == KeyEvent.VK_SPACE) {
            // Zmiana trybu wzgldnego myszy:
            relativeMouseMode = !relativeMouseMode;
        }
    }

    // Z interfejsu KeyListener:
    public void keyReleased(KeyEvent e) {
        // Nic nie wykonuj.
    }

    // Z interfejsu KeyListener:
    public void keyTyped(KeyEvent e) {
        // Nic nie wykonuj.
    }
}
