/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame;

import com.brackeen.javagamebook.input.InputManager;
import com.brackeen.javagamebook.sound.MidiPlayer;
import com.brackeen.javagamebook.sound.SoundManager;
import com.brackeen.javagamebook.state.GameStateManager;
import com.brackeen.javagamebook.state.ResourceManager;
import com.brackeen.javagamebook.test.GameCore;
import com.brackeen.javagamebook.tilegame.MainGameState;
import com.brackeen.javagamebook.tilegame.SplashGameState;
import com.brackeen.javagamebook.tilegame.TileGameResourceManager;
import com.brackeen.javagamebook.util.TimeSmoothie;
import java.awt.Graphics2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class GameManager
extends GameCore {
    static final Logger log = Logger.getLogger("com.brackeen.javagamebook.tilegame");
    private static final AudioFormat PLAYBACK_FORMAT = new AudioFormat(44100.0f, 16, 1, true, false);
    private MidiPlayer midiPlayer;
    private SoundManager soundManager;
    private ResourceManager resourceManager;
    private InputManager inputManager;
    private GameStateManager gameStateManager;
    private TimeSmoothie timeSmoothie = new TimeSmoothie();

    public static void main(String[] args) {
        new GameManager().run();
    }

    public void init() {
        log.setLevel(Level.INFO);
        log.info("init sound manager");
        this.soundManager = new SoundManager(PLAYBACK_FORMAT, 8);
        log.info("init midi player");
        this.midiPlayer = new MidiPlayer();
        log.info("init gamecore");
        super.init();
        log.info("init input manager");
        this.inputManager = new InputManager(this.screen.getFullScreenWindow());
        this.inputManager.setCursor(InputManager.INVISIBLE_CURSOR);
        log.info("init resource manager");
        this.resourceManager = new TileGameResourceManager(this.screen.getFullScreenWindow().getGraphicsConfiguration(), this.soundManager, this.midiPlayer);
        log.info("init game states");
        this.gameStateManager = new GameStateManager(this.inputManager, this.resourceManager.loadImage("loadingsplash.jpg"));
        this.gameStateManager.addState(new MainGameState(this.soundManager, this.midiPlayer, this.screen.getWidth(), this.screen.getHeight()));
        this.gameStateManager.addState(new SplashGameState("gamesplash.jpg"));
        new Thread(){

            public void run() {
                log.info("loading resources");
                GameManager.this.gameStateManager.loadAllResources(GameManager.this.resourceManager);
                log.info("setting to Splash state");
                GameManager.this.gameStateManager.setState("Splash");
            }
        }.start();
    }

    public void stop() {
        log.info("stopping game");
        super.stop();
        log.info("closing midi player");
        this.midiPlayer.close();
        log.info("closing sound manager");
        this.soundManager.close();
    }

    public void update(long elapsedTime) {
        if (this.gameStateManager.isDone()) {
            this.stop();
        } else {
            elapsedTime = this.timeSmoothie.getTime(elapsedTime);
            this.gameStateManager.update(elapsedTime);
        }
    }

    public void draw(Graphics2D g) {
        this.gameStateManager.draw(g);
    }
}

