/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.state;

import com.brackeen.javagamebook.sound.MidiPlayer;
import com.brackeen.javagamebook.sound.Sound;
import com.brackeen.javagamebook.sound.SoundManager;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.sound.midi.Sequence;
import javax.swing.ImageIcon;

public class ResourceManager {
    private GraphicsConfiguration gc;
    private SoundManager soundManager;
    private MidiPlayer midiPlayer;

    public ResourceManager(GraphicsConfiguration gc, SoundManager soundManager, MidiPlayer midiPlayer) {
        this.gc = gc;
        this.soundManager = soundManager;
        this.midiPlayer = midiPlayer;
        try {
            Enumeration<URL> e = this.getClass().getClassLoader().getResources("com.brackeen.javagamebook.state.ResourceManager");
            while (e.hasMoreElements()) {
                System.out.println(e.nextElement());
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public Image loadImage(String name) {
        String filename = "images/" + name;
        return new ImageIcon(this.getResource(filename)).getImage();
    }

    public Image getMirrorImage(Image image) {
        return this.getScaledImage(image, -1.0f, 1.0f);
    }

    public Image getFlippedImage(Image image) {
        return this.getScaledImage(image, 1.0f, -1.0f);
    }

    private Image getScaledImage(Image image, float x, float y) {
        AffineTransform transform = new AffineTransform();
        transform.scale(x, y);
        transform.translate((x - 1.0f) * (float)image.getWidth(null) / 2.0f, (y - 1.0f) * (float)image.getHeight(null) / 2.0f);
        BufferedImage newImage = this.gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = (Graphics2D)((Image)newImage).getGraphics();
        g.drawImage(image, transform, null);
        g.dispose();
        return newImage;
    }

    public URL getResource(String filename) {
        return this.getClass().getClassLoader().getResource(filename);
    }

    public InputStream getResourceAsStream(String filename) {
        return this.getClass().getClassLoader().getResourceAsStream(filename);
    }

    public Sound loadSound(String name) {
        return this.soundManager.getSound(this.getResourceAsStream(name));
    }

    public Sequence loadSequence(String name) {
        return this.midiPlayer.getSequence(this.getResourceAsStream(name));
    }
}

