/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame;

import com.brackeen.javagamebook.input.GameAction;
import com.brackeen.javagamebook.input.InputManager;
import com.brackeen.javagamebook.state.GameState;
import com.brackeen.javagamebook.state.ResourceManager;
import java.awt.Graphics2D;
import java.awt.Image;

public class SplashGameState
implements GameState {
    private String splashFilename;
    private Image splash;
    private GameAction exitSplash = new GameAction("exitSplash", 1);
    private long totalElapsedTime;
    private boolean done;

    public SplashGameState(String splashFilename) {
        this.splashFilename = splashFilename;
    }

    public String getName() {
        return "Splash";
    }

    public void loadResources(ResourceManager resourceManager) {
        this.splash = resourceManager.loadImage(this.splashFilename);
    }

    public String checkForStateChange() {
        return this.done ? "Main" : null;
    }

    public void start(InputManager inputManager) {
        inputManager.mapToKey(this.exitSplash, 32);
        inputManager.mapToMouse(this.exitSplash, 6);
        this.totalElapsedTime = 0L;
        this.done = false;
    }

    public void stop() {
    }

    public void update(long elapsedTime) {
        this.totalElapsedTime += elapsedTime;
        if (this.totalElapsedTime > 3000L || this.exitSplash.isPressed()) {
            this.done = true;
        }
    }

    public void draw(Graphics2D g) {
        g.drawImage(this.splash, 0, 0, null);
    }
}

