/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.sound;

import com.brackeen.javagamebook.graphics.Sprite;
import com.brackeen.javagamebook.sound.SoundFilter;

public class Filter3d
extends SoundFilter {
    private static final int NUM_SHIFTING_SAMPLES = 500;
    private Sprite source;
    private Sprite listener;
    private int maxDistance;
    private float lastVolume;

    public Filter3d(Sprite source, Sprite listener, int maxDistance) {
        this.source = source;
        this.listener = listener;
        this.maxDistance = maxDistance;
        this.lastVolume = 0.0f;
    }

    public void filter(byte[] samples, int offset, int length) {
        float dy;
        if (this.source == null || this.listener == null) {
            return;
        }
        float dx = this.source.getX() - this.listener.getX();
        float distance = (float)Math.sqrt(dx * dx + (dy = this.source.getY() - this.listener.getY()) * dy);
        float newVolume = ((float)this.maxDistance - distance) / (float)this.maxDistance;
        if (newVolume <= 0.0f) {
            newVolume = 0.0f;
        }
        int shift = 0;
        for (int i = offset; i < offset + length; i += 2) {
            float volume = newVolume;
            if (shift < 500) {
                volume = this.lastVolume + (newVolume - this.lastVolume) * (float)shift / 500.0f;
                ++shift;
            }
            short oldSample = Filter3d.getSample(samples, i);
            short newSample = (short)((float)oldSample * volume);
            Filter3d.setSample(samples, i, newSample);
        }
        this.lastVolume = newVolume;
    }
}

