/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.input;

import com.brackeen.javagamebook.input.GameAction;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class InputManager
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final Cursor INVISIBLE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(""), new Point(0, 0), "invisible");
    public static final int MOUSE_MOVE_LEFT = 0;
    public static final int MOUSE_MOVE_RIGHT = 1;
    public static final int MOUSE_MOVE_UP = 2;
    public static final int MOUSE_MOVE_DOWN = 3;
    public static final int MOUSE_WHEEL_UP = 4;
    public static final int MOUSE_WHEEL_DOWN = 5;
    public static final int MOUSE_BUTTON_1 = 6;
    public static final int MOUSE_BUTTON_2 = 7;
    public static final int MOUSE_BUTTON_3 = 8;
    private static final int NUM_MOUSE_CODES = 9;
    private static final int NUM_KEY_CODES = 600;
    private GameAction[] keyActions = new GameAction[600];
    private GameAction[] mouseActions = new GameAction[9];
    private Point mouseLocation;
    private Point centerLocation;
    private Component comp;
    private Robot robot;
    private boolean isRecentering;

    public InputManager(Component comp) {
        this.comp = comp;
        this.mouseLocation = new Point();
        this.centerLocation = new Point();
        comp.addKeyListener(this);
        comp.addMouseListener(this);
        comp.addMouseMotionListener(this);
        comp.addMouseWheelListener(this);
        comp.setFocusTraversalKeysEnabled(false);
    }

    public void setCursor(Cursor cursor) {
        this.comp.setCursor(cursor);
    }

    public void setRelativeMouseMode(boolean mode) {
        if (mode == this.isRelativeMouseMode()) {
            return;
        }
        if (mode) {
            try {
                this.robot = new Robot();
                this.recenterMouse();
            }
            catch (AWTException ex) {
                this.robot = null;
            }
        } else {
            this.robot = null;
        }
    }

    public boolean isRelativeMouseMode() {
        return this.robot != null;
    }

    public void mapToKey(GameAction gameAction, int keyCode) {
        this.keyActions[keyCode] = gameAction;
    }

    public void mapToMouse(GameAction gameAction, int mouseCode) {
        this.mouseActions[mouseCode] = gameAction;
    }

    public void clearMap(GameAction gameAction) {
        int i;
        for (i = 0; i < this.keyActions.length; ++i) {
            if (this.keyActions[i] != gameAction) continue;
            this.keyActions[i] = null;
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            if (this.mouseActions[i] != gameAction) continue;
            this.mouseActions[i] = null;
        }
        gameAction.reset();
    }

    public void clearAllMaps() {
        int i;
        for (i = 0; i < this.keyActions.length; ++i) {
            this.keyActions[i] = null;
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            this.mouseActions[i] = null;
        }
    }

    public List getMaps(GameAction gameCode) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < this.keyActions.length; ++i) {
            if (this.keyActions[i] != gameCode) continue;
            list.add(InputManager.getKeyName(i));
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            if (this.mouseActions[i] != gameCode) continue;
            list.add(InputManager.getMouseName(i));
        }
        return list;
    }

    public void resetAllGameActions() {
        int i;
        for (i = 0; i < this.keyActions.length; ++i) {
            if (this.keyActions[i] == null) continue;
            this.keyActions[i].reset();
        }
        for (i = 0; i < this.mouseActions.length; ++i) {
            if (this.mouseActions[i] == null) continue;
            this.mouseActions[i].reset();
        }
    }

    public static String getKeyName(int keyCode) {
        return KeyEvent.getKeyText(keyCode);
    }

    public static String getMouseName(int mouseCode) {
        switch (mouseCode) {
            case 0: {
                return "Mysz lewo";
            }
            case 1: {
                return "Mysz prawo";
            }
            case 2: {
                return "Mysz g\u00f3ra";
            }
            case 3: {
                return "Mysz d\u00f3\u0142";
            }
            case 4: {
                return "K\u00f3\u0142ko myszy g\u00f3ra";
            }
            case 5: {
                return "K\u00f3\u0142ko myszy d\u00f3\u0142";
            }
            case 6: {
                return "Przycisk myszy 1";
            }
            case 7: {
                return "Przycisk myszy 2";
            }
            case 8: {
                return "Przycisk myszy 3";
            }
        }
        return "Nieznany kod zdarzenia myszy " + mouseCode;
    }

    public int getMouseX() {
        return this.mouseLocation.x;
    }

    public int getMouseY() {
        return this.mouseLocation.y;
    }

    private synchronized void recenterMouse() {
        if (this.robot != null && this.comp.isShowing()) {
            this.centerLocation.x = this.comp.getWidth() / 2;
            this.centerLocation.y = this.comp.getHeight() / 2;
            SwingUtilities.convertPointToScreen(this.centerLocation, this.comp);
            this.isRecentering = true;
            this.robot.mouseMove(this.centerLocation.x, this.centerLocation.y);
        }
    }

    private GameAction getKeyAction(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode < this.keyActions.length) {
            return this.keyActions[keyCode];
        }
        return null;
    }

    public static int getMouseButtonCode(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                return 6;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 8;
            }
        }
        return -1;
    }

    private GameAction getMouseButtonAction(MouseEvent e) {
        int mouseCode = InputManager.getMouseButtonCode(e);
        if (mouseCode != -1) {
            return this.mouseActions[mouseCode];
        }
        return null;
    }

    public void keyPressed(KeyEvent e) {
        GameAction gameAction = this.getKeyAction(e);
        if (gameAction != null) {
            gameAction.press();
        }
        e.consume();
    }

    public void keyReleased(KeyEvent e) {
        GameAction gameAction = this.getKeyAction(e);
        if (gameAction != null) {
            gameAction.release();
        }
        e.consume();
    }

    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        GameAction gameAction = this.getMouseButtonAction(e);
        if (gameAction != null) {
            gameAction.press();
        }
    }

    public void mouseReleased(MouseEvent e) {
        GameAction gameAction = this.getMouseButtonAction(e);
        if (gameAction != null) {
            gameAction.release();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public synchronized void mouseMoved(MouseEvent e) {
        if (this.isRecentering && this.centerLocation.x == e.getX() && this.centerLocation.y == e.getY()) {
            this.isRecentering = false;
        } else {
            int dx = e.getX() - this.mouseLocation.x;
            int dy = e.getY() - this.mouseLocation.y;
            this.mouseHelper(0, 1, dx);
            this.mouseHelper(2, 3, dy);
            if (this.isRelativeMouseMode()) {
                this.recenterMouse();
            }
        }
        this.mouseLocation.x = e.getX();
        this.mouseLocation.y = e.getY();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseHelper(4, 5, e.getWheelRotation());
    }

    private void mouseHelper(int codeNeg, int codePos, int amount) {
        GameAction gameAction = amount < 0 ? this.mouseActions[codeNeg] : this.mouseActions[codePos];
        if (gameAction != null) {
            gameAction.press(Math.abs(amount));
            gameAction.release();
        }
    }
}

