/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.input;

public class GameAction {
    public static final int NORMAL = 0;
    public static final int DETECT_INITAL_PRESS_ONLY = 1;
    private static final int STATE_RELEASED = 0;
    private static final int STATE_PRESSED = 1;
    private static final int STATE_WAITING_FOR_RELEASE = 2;
    private String name;
    private int behavior;
    private int amount;
    private int state;

    public GameAction(String name) {
        this(name, 0);
    }

    public GameAction(String name, int behavior) {
        this.name = name;
        this.behavior = behavior;
        this.reset();
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        this.state = 0;
        this.amount = 0;
    }

    public synchronized void tap() {
        this.press();
        this.release();
    }

    public synchronized void press() {
        this.press(1);
    }

    public synchronized void press(int amount) {
        if (this.state != 2) {
            this.amount += amount;
            this.state = 1;
        }
    }

    public synchronized void release() {
        this.state = 0;
    }

    public synchronized boolean isPressed() {
        return this.getAmount() != 0;
    }

    public synchronized int getAmount() {
        int retVal = this.amount;
        if (retVal != 0) {
            if (this.state == 0) {
                this.amount = 0;
            } else if (this.behavior == 1) {
                this.state = 2;
                this.amount = 0;
            }
        }
        return retVal;
    }
}

