/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame;

import com.brackeen.javagamebook.graphics.Sprite;
import com.brackeen.javagamebook.tilegame.TileMap;
import com.brackeen.javagamebook.tilegame.sprites.Creature;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Iterator;

public class TileMapRenderer {
    private static final int TILE_SIZE = 64;
    private static final int TILE_SIZE_BITS = 6;
    private Image background;

    public static int pixelsToTiles(float pixels) {
        return TileMapRenderer.pixelsToTiles(Math.round(pixels));
    }

    public static int pixelsToTiles(int pixels) {
        return pixels >> 6;
    }

    public static int tilesToPixels(int numTiles) {
        return numTiles << 6;
    }

    public void setBackground(Image background) {
        this.background = background;
    }

    public void draw(Graphics2D g, TileMap map, int screenWidth, int screenHeight) {
        Sprite player = map.getPlayer();
        int mapWidth = TileMapRenderer.tilesToPixels(map.getWidth());
        int offsetX = screenWidth / 2 - Math.round(player.getX()) - 64;
        offsetX = Math.min(offsetX, 0);
        offsetX = Math.max(offsetX, screenWidth - mapWidth);
        int offsetY = screenHeight - TileMapRenderer.tilesToPixels(map.getHeight());
        if (this.background == null || screenHeight > this.background.getHeight(null)) {
            g.setColor(Color.black);
            g.fillRect(0, 0, screenWidth, screenHeight);
        }
        if (this.background != null) {
            int x = offsetX * (screenWidth - this.background.getWidth(null)) / (screenWidth - mapWidth);
            int y = screenHeight - this.background.getHeight(null);
            g.drawImage(this.background, x, y, null);
        }
        int firstTileX = TileMapRenderer.pixelsToTiles(-offsetX);
        int lastTileX = firstTileX + TileMapRenderer.pixelsToTiles(screenWidth) + 1;
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = firstTileX; x <= lastTileX; ++x) {
                Image image = map.getTile(x, y);
                if (image == null) continue;
                g.drawImage(image, TileMapRenderer.tilesToPixels(x) + offsetX, TileMapRenderer.tilesToPixels(y) + offsetY, null);
            }
        }
        g.drawImage(player.getImage(), Math.round(player.getX()) + offsetX, Math.round(player.getY()) + offsetY, null);
        Iterator i = map.getSprites();
        while (i.hasNext()) {
            Sprite sprite = (Sprite)i.next();
            int x = Math.round(sprite.getX()) + offsetX;
            int y = Math.round(sprite.getY()) + offsetY;
            g.drawImage(sprite.getImage(), x, y, null);
            if (!(sprite instanceof Creature) || x < 0 || x >= screenWidth) continue;
            ((Creature)sprite).wakeUp();
        }
    }
}

