/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame;

import com.brackeen.javagamebook.graphics.Sprite;
import java.awt.Image;
import java.util.Iterator;
import java.util.LinkedList;

public class TileMap {
    private Image[][] tiles;
    private LinkedList sprites;
    private Sprite player;

    public TileMap(int width, int height) {
        this.tiles = new Image[width][height];
        this.sprites = new LinkedList();
    }

    public int getWidth() {
        return this.tiles.length;
    }

    public int getHeight() {
        return this.tiles[0].length;
    }

    public Image getTile(int x, int y) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return null;
        }
        return this.tiles[x][y];
    }

    public void setTile(int x, int y, Image tile) {
        this.tiles[x][y] = tile;
    }

    public Sprite getPlayer() {
        return this.player;
    }

    public void setPlayer(Sprite player) {
        this.player = player;
    }

    public void addSprite(Sprite sprite) {
        this.sprites.add(sprite);
    }

    public void removeSprite(Sprite sprite) {
        this.sprites.remove(sprite);
    }

    public Iterator getSprites() {
        return this.sprites.iterator();
    }
}

