/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.sound;

import com.brackeen.javagamebook.sound.SoundFilter;

public class EchoFilter
extends SoundFilter {
    private short[] delayBuffer;
    private int delayBufferPos;
    private float decay;

    public EchoFilter(int numDelaySamples, float decay) {
        this.delayBuffer = new short[numDelaySamples];
        this.decay = decay;
    }

    public int getRemainingSize() {
        float finalDecay = 0.01f;
        int numRemainingBuffers = (int)Math.ceil(Math.log(finalDecay) / Math.log(this.decay));
        int bufferSize = this.delayBuffer.length * 2;
        return bufferSize * numRemainingBuffers;
    }

    public void reset() {
        for (int i = 0; i < this.delayBuffer.length; ++i) {
            this.delayBuffer[i] = 0;
        }
        this.delayBufferPos = 0;
    }

    public void filter(byte[] samples, int offset, int length) {
        for (int i = offset; i < offset + length; i += 2) {
            short oldSample = EchoFilter.getSample(samples, i);
            short newSample = (short)((float)oldSample + this.decay * (float)this.delayBuffer[this.delayBufferPos]);
            EchoFilter.setSample(samples, i, newSample);
            this.delayBuffer[this.delayBufferPos] = newSample;
            ++this.delayBufferPos;
            if (this.delayBufferPos != this.delayBuffer.length) continue;
            this.delayBufferPos = 0;
        }
    }
}

