/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.tilegame.sprites;

import com.brackeen.javagamebook.graphics.Animation;
import com.brackeen.javagamebook.tilegame.sprites.Creature;

public class Player
extends Creature {
    private static final float JUMP_SPEED = -0.95f;
    private boolean onGround;

    public Player(Animation left, Animation right, Animation deadLeft, Animation deadRight) {
        super(left, right, deadLeft, deadRight);
    }

    public void collideHorizontal() {
        this.setVelocityX(0.0f);
    }

    public void collideVertical() {
        if (this.getVelocityY() > 0.0f) {
            this.onGround = true;
        }
        this.setVelocityY(0.0f);
    }

    public void setY(float y) {
        if (Math.round(y) > Math.round(this.getY())) {
            this.onGround = false;
        }
        super.setY(y);
    }

    public void wakeUp() {
    }

    public void jump(boolean forceJump) {
        if (this.onGround || forceJump) {
            this.onGround = false;
            this.setVelocityY(-0.95f);
        }
    }

    public float getMaxSpeed() {
        return 0.5f;
    }
}

