/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.sound;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class MidiPlayer
implements MetaEventListener {
    public static final int END_OF_TRACK_MESSAGE = 47;
    private Sequencer sequencer;
    private boolean loop;
    private boolean paused;

    public MidiPlayer() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.addMetaEventListener(this);
        }
        catch (MidiUnavailableException ex) {
            this.sequencer = null;
        }
    }

    public Sequence getSequence(String filename) {
        try {
            return this.getSequence(new FileInputStream(filename));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Sequence getSequence(InputStream is) {
        try {
            if (!is.markSupported()) {
                is = new BufferedInputStream(is);
            }
            Sequence s = MidiSystem.getSequence(is);
            is.close();
            return s;
        }
        catch (InvalidMidiDataException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void play(Sequence sequence, boolean loop) {
        if (this.sequencer != null && sequence != null && this.sequencer.isOpen()) {
            try {
                this.sequencer.setSequence(sequence);
                this.sequencer.start();
                this.loop = loop;
            }
            catch (InvalidMidiDataException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void meta(MetaMessage event) {
        if (event.getType() == 47 && this.sequencer != null && this.sequencer.isOpen() && this.loop) {
            this.sequencer.start();
        }
    }

    public void stop() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.setMicrosecondPosition(0L);
        }
    }

    public void close() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public void setPaused(boolean paused) {
        if (this.paused != paused && this.sequencer != null && this.sequencer.isOpen()) {
            this.paused = paused;
            if (paused) {
                this.sequencer.stop();
            } else {
                this.sequencer.start();
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }
}

