/*
 * Decompiled with CFR 0.152.
 */
package com.brackeen.javagamebook.graphics;

import java.awt.Image;
import java.util.ArrayList;

public class Animation {
    private ArrayList frames;
    private int currFrameIndex;
    private long animTime;
    private long totalDuration;

    public Animation() {
        this(new ArrayList(), 0L);
    }

    private Animation(ArrayList frames, long totalDuration) {
        this.frames = frames;
        this.totalDuration = totalDuration;
        this.start();
    }

    public Object clone() {
        return new Animation(this.frames, this.totalDuration);
    }

    public synchronized void addFrame(Image image, long duration) {
        this.totalDuration += duration;
        this.frames.add(new AnimFrame(image, this.totalDuration));
    }

    public synchronized void start() {
        this.animTime = 0L;
        this.currFrameIndex = 0;
    }

    public synchronized void update(long elapsedTime) {
        if (this.frames.size() > 1) {
            this.animTime += elapsedTime;
            if (this.animTime >= this.totalDuration) {
                this.animTime %= this.totalDuration;
                this.currFrameIndex = 0;
            }
            while (this.animTime > this.getFrame((int)this.currFrameIndex).endTime) {
                ++this.currFrameIndex;
            }
        }
    }

    public synchronized Image getImage() {
        if (this.frames.size() == 0) {
            return null;
        }
        return this.getFrame((int)this.currFrameIndex).image;
    }

    private AnimFrame getFrame(int i) {
        return (AnimFrame)this.frames.get(i);
    }

    private class AnimFrame {
        Image image;
        long endTime;

        public AnimFrame(Image image, long endTime) {
            this.image = image;
            this.endTime = endTime;
        }
    }
}

