package rozdzial18.monikairobert;


import java.util.concurrent.*;

public class MonikaIRobertSynchronizowaniTest {
  public static void main(String[] args) throws InterruptedException {
    for (int i = 0; i < 10; i++) {
      final KontoBankoweSynchronizowani account = new KontoBankoweSynchronizowani();
      MonikaIRobertSynchronizowani robert = new MonikaIRobertSynchronizowani("Robert", account, 50);
      MonikaIRobertSynchronizowani monika = new MonikaIRobertSynchronizowani("Monika", account, 100);
      ExecutorService wykonawca = Executors.newFixedThreadPool(2);
      wykonawca.execute(robert);
      wykonawca.execute(monika);
      wykonawca.shutdown();
      //wykonawca.awaitTermination(1, TimeUnit.MINUTES);
      //System.out.println("---");
    }
  }
}

class MonikaIRobertSynchronizowani implements Runnable {
  private final String imie;
  private final KontoBankoweSynchronizowani konto;
  private final int kwotaDoWydania;

  MonikaIRobertSynchronizowani(String imie, KontoBankoweSynchronizowani konto, int kwotaDoWydania) {
    this.imie = imie;
    this.konto = konto;
    this.kwotaDoWydania = kwotaDoWydania;
  }

  public void run() {
    zrobZakupy(kwotaDoWydania);
  }

  private void zrobZakupy(int kwota) {
    synchronized (konto) {
      if (konto.getStan() >= kwota) {
        System.out.println(imie + " zamierza wydać trochę pieniędzy.");
        konto.wydaj(kwota);
        System.out.println(imie + " kończy zakupy.");
      } else {
        System.out.println("Przykro mi, nie masz tylu pieniędzy, " + imie + ".");
      }      
    }
  }
}

class KontoBankoweSynchronizowani {
  private int stan = 100;

  public int getStan() {
    return stan;
  }

  public void wydaj(int kwota) {
    stan = stan - kwota;
    if (stan < 0) {
      System.out.println("Przekroczenie limitu!");
    }
  }
}


