package rozdzial18.monikairobert;


import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MonikaIRobertKontoSynchroTest {
  public static void main(String[] args) throws InterruptedException {
    for (int i = 0; i < 10; i++) {
      KontoBankoweSynchro konto = new KontoBankoweSynchro();
      MonikaIRobertKontoSynchro robert = new MonikaIRobertKontoSynchro("Robert", konto, 50);
      MonikaIRobertKontoSynchro monika = new MonikaIRobertKontoSynchro("Monika", konto, 100);
      ExecutorService wykonawca = Executors.newFixedThreadPool(2);
      wykonawca.execute(robert);
      wykonawca.execute(monika);
      wykonawca.shutdown();
      wykonawca.awaitTermination(1, TimeUnit.MINUTES);
      System.out.println("---");
    }
  }
}

class MonikaIRobertKontoSynchro implements Runnable {
  private final String imie;
  private final KontoBankoweSynchro konto;
  private final int kwotaDoWydania;

  MonikaIRobertKontoSynchro(String imie, KontoBankoweSynchro konto, int kwotaDoWydania) {
    this.imie = imie;
    this.konto = konto;
    this.kwotaDoWydania = kwotaDoWydania;
  }

  public void run() {
    zrobZakupy(kwotaDoWydania);
  }

  private void zrobZakupy(int kwota) {
    System.out.println(imie + " zamierza wydać trochę pieniędzy.");
    konto.wydaj(imie, kwota);
    System.out.println(imie + " kończy zakupy.");
  }
}

class KontoBankoweSynchro {
  private int stan = 100;

  public int getStan() {
    return stan;
  }

  public synchronized void wydaj(String imie, int kwota) {
    if (getStan() >= kwota) {
      stan = stan - kwota;
      if (stan < 0) {
        System.out.println("Przekroczenie limitu!");
      }
    } else {
      System.out.println("Przykro mi, nie masz tylu pieniędzy, " + imie + ".");
    }
  }
}
