package rozdzial18;


import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class UtraconaAktualizacja {
  public static void main(String[] args) throws InterruptedException {
    ExecutorService pula = Executors.newFixedThreadPool(30);
    //AtomowyStanKonta stanKonta = new AtomowyStanKonta();
    StanKonta stanKonta = new StanKonta();
    for (int i = 0; i < 1000; i++) {
      pula.execute(() -> stanKonta.inkrementuj());
    }
    pula.shutdown();
    // przed wyświetleniem wyniku upewnij się, wykonywanie wszystkich wątków
    // w puli zostało zakończone
    if (pula.awaitTermination(1, TimeUnit.MINUTES)) {
      System.out.println("stanKonta = " + stanKonta.stanKonta);
    }
  }
}

class StanKonta {
  int stanKonta = 0;

  // dodaj tu słowo kluczowe synchronized, by kod zaczął działać poprawnie
  public void inkrementuj() {
    stanKonta++;
  }
}

class AtomowyStanKonta {
  AtomicInteger stanKonta = new AtomicInteger(0);

  public void inkrementuj() {
    stanKonta.incrementAndGet();
  }
}

