package rozdzial17.magnesiki;

import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;
import java.time.format.FormatStyle;
import java.util.concurrent.TimeUnit;

import static java.nio.charset.StandardCharsets.UTF_8;
import static java.time.LocalDateTime.now;
import static java.time.format.DateTimeFormatter.ofLocalizedTime;

public class KlientPingowania {

  public static void main(String[] args) {
    InetSocketAddress serwer = new InetSocketAddress("127.0.0.1", 5000);
    try (SocketChannel kanal = SocketChannel.open(serwer)) {
      PrintWriter pisarz = new PrintWriter(Channels.newWriter(kanal, UTF_8));
      System.out.println("Obsługa sieci została uruchomiona.");

      for (int i = 0; i < 10; i++) {
        String wiadomosc = "ping " + i;
        pisarz.println(wiadomosc);
        pisarz.flush();
        String biezacaGodzina = now().format(ofLocalizedTime(FormatStyle.MEDIUM));
        System.out.println(biezacaGodzina + " wysłano " + wiadomosc);
        TimeUnit.SECONDS.sleep(1);
      }
    } catch (IOException | InterruptedException ex) {
      ex.printStackTrace();
    }
  }
}