package rozdzial14;

import javax.sound.midi.*;
import javax.swing.*;
import java.awt.*;
import java.util.Random;

import static javax.sound.midi.ShortMessage.*;

public class Miniodtwarzacz3 {
  private MojPanelGraf panel;
  private Random losowa = new Random();

  public static void main(String[] args) {
    Miniodtwarzacz3 mini = new Miniodtwarzacz3();
    mini.doRoboty();
  }
  
  public void konfigurujGUI() {
    JFrame ramka = new JFrame("Moje pierwsze muzyczne wideo");
    panel = new MojPanelGraf();
    ramka.setContentPane(panel);
    ramka.setBounds(30, 30, 300, 300);
    ramka.setVisible(true);
  }
  
  public void doRoboty() {
    konfigurujGUI();
    
    try {
      Sequencer sekwenser = MidiSystem.getSequencer();
      sekwenser.open();
      sekwenser.addControllerEventListener(panel, new int[]{127});
      Sequence sekw = new Sequence(Sequence.PPQ, 4);
      Track sciezka = sekw.createTrack();
      
      int nuta;
      for (int i = 0; i < 60; i += 4) {
        nuta = losowa.nextInt(50) + 1;
        sciezka.add(tworzZdarzenie(NOTE_ON, 1, nuta, 100, i));
        sciezka.add(tworzZdarzenie(CONTROL_CHANGE, 1, 127, 0, i));
        sciezka.add(tworzZdarzenie(NOTE_OFF, 1, nuta, 100, i + 2));
      }
      
      sekwenser.setSequence(sekw);
      sekwenser.start();
      sekwenser.setTempoInBPM(120);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }
  
  public static MidiEvent tworzZdarzenie(int plc, int kanal, int jeden, int dwa, int takt) {
    MidiEvent zdarzenie = null;
    try {
      ShortMessage msg = new ShortMessage();
      msg.setMessage(plc, kanal, jeden, dwa);
      zdarzenie = new MidiEvent(msg, takt);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    return zdarzenie;
  }
  
  class MojPanelGraf extends JPanel implements ControllerEventListener {
    private boolean komunikat = false;
    
    public void controlChange(ShortMessage zdarzenie) {
      komunikat = true;
      repaint();
    }
    
    public void paintComponent(Graphics g) {
      if (komunikat) {
        int c = losowa.nextInt(250);
        int z = losowa.nextInt(250);
        int n = losowa.nextInt(250);
        
        g.setColor(new Color(c, z, n));
        
        int wys = losowa.nextInt(120) + 10;
        int szer = losowa.nextInt(120) + 10;
        
        int wspX = losowa.nextInt(40) + 10;
        int wspY = losowa.nextInt(40) + 10;
        
        g.fillRect(wspX, wspY, szer, wys);
        komunikat = false;
      }
    }
  }  
  
}