package rozdzial06;

import java.util.*;

public class PomocnikGry {
  private static final String ALFABET = "abcdefg";
  private static final int PLANSZA_DLUGOSC = 7;
  private static final int PLANSZA_WIELKOSC = 49;
  private static final int MAX_PROB = 200;
  static final int INKREMENTACJA_W_POZ = 1; // lepszym sposobem wyrażenia tych dwóch informacji
  static final int INKREMENTACJA_W_PION = PLANSZA_DLUGOSC; // jest użycie typu wyliczeniowego (patrz Dodatek B)  
  
  private final int [] plansza = new int[PLANSZA_WIELKOSC];
  private final Random liczbaLosowa = new Random();
  private int liczbaStartupow = 0;  

  public String pobierzDaneWejsciowe(String komunikat) {
    System.out.print(komunikat + ": ");
    Scanner skaner = new Scanner(System.in);
    return skaner.nextLine().toLowerCase();
  } // koniec metody
  
  public ArrayList<String> rozmiescStartup(int wielkoscStartupu) {
    
    // zawiera indeks do planszy (0 - 48)
    int[] wspolrzedneStartupu = new int[wielkoscStartupu];    // bieżące rozpatrywane współrzędne
    int proby = 0;                                            // licznik prób
    boolean czySieUdalo = false;                              // flaga = znaleziono dobre położenie?
    liczbaStartupow++;                                        // n-ty startup do rozmieszczenia
    int wartoscInkrementacji = getWartoscInkrementacji();     // alternatywne wyrównanie w pionie/poziomie
    while (!czySieUdalo & proby++ < MAX_PROB) {               // główna pętla wyszukiwania
      int polozenie = liczbaLosowa.nextInt(PLANSZA_WIELKOSC); // pobieramy losowy punkt początkowy
      for (int i = 0; i < wspolrzedneStartupu.length; i++) {  // tworzymy tablicę proponowanych współrzędnych
        wspolrzedneStartupu[i] = polozenie;                   // zapisujemy bieżące położenie w tablicy
        polozenie += wartoscInkrementacji;                    // obliczamy następne położenie 
      }
      // System.out.println("Próbujemy: " + Arrays.toString(wspolrzedneStartupu));
      
      if (czyStartupPasuje(wspolrzedneStartupu, wartoscInkrementacji)) {  // czy startup pasuje?
        czySieUdalo = czyWspolrzedneDostepne(wspolrzedneStartupu);   // ...i pola nie są zajęte?
      }                                                       // koniec if
    }                                                         // koniec pętli while
    
    zapiszPolozenieNaPlanszy(wspolrzedneStartupu); // współrzędne ok, zapisujemy
    ArrayList<String> komorkiAlfaNum = konwertujPolozenieDoFormatuAlfaNum(wspolrzedneStartupu);
    // System.out.println("Startup umieszczono w polu: "+ komorkiAlfaNum);
    return komorkiAlfaNum;    
  } // koniec metody
  
  private boolean czyStartupPasuje(int[] wspolrzedneStartupu, int wartInkrementacji) {
    int koncowePolozenie = wspolrzedneStartupu[wspolrzedneStartupu.length - 1];
    if (wartInkrementacji == INKREMENTACJA_W_POZ) {
      // sprawdzamy czy koniec jest w tym samym wierszu co początek
      return obliczWierszZIndeksu(wspolrzedneStartupu[0]) == obliczWierszZIndeksu(koncowePolozenie);
    } else {
      return koncowePolozenie < PLANSZA_WIELKOSC;               // czy koniec nie jest poniżej dołu planszy?
    }
  } // koniec metody
    
  private boolean czyWspolrzedneDostepne(int[] wspolrzedneStartupu) {
    for (int wspolrzedna : wspolrzedneStartupu) {               // sprawdzamy wszystkie potencjalne położenia
      if (plansza[wspolrzedna] != 0) {                          // to położenie zostało już użyte
        // System.out.println("współrzędne: " + coord + " są zajęte.");
        return false;                                           // BRAK powodzenia
      }
    }
    return true;                                                // nie było kolizji, super!
  } // koniec metody
    
  private void zapiszPolozenieNaPlanszy(int[] wspolrzedneStartupu) {
    for (int indeks : wspolrzedneStartupu) {
      plansza[indeks] = 1;                                      // oznaczamy pole planszy jako "zajęte"
    }
  } // koniec metody
    
  private ArrayList<String> konwertujPolozenieDoFormatuAlfaNum(int[] wspolrzedneStartupu) {
    ArrayList<String> komorkiAlfaNum = new ArrayList<String>();
    for (int indeks : wspolrzedneStartupu) {                    // dla każdego położenia na planszy
      String wspolrzedneAlfaNum = pobierzWspolrzedneAlfaNumNaPdstwIndeksu(indeks);  
                                                                // zmieniamy na zapis typu "a0"
      komorkiAlfaNum.add(wspolrzedneAlfaNum);                   // dodajemy do listy
    }
    return komorkiAlfaNum;                                      // zwracamy współrzędne w zapisie "a0"
  } // koniec metody
    
  private String pobierzWspolrzedneAlfaNumNaPdstwIndeksu(int indeks) {
    int wiersz = obliczWierszZIndeksu(indeks);                 // pobieramy wartośc wiersza
    int kolumna = indeks % PLANSZA_DLUGOSC;                    // pobieramy liczbową wartość kolumny
    String litera = ALFABET.substring(kolumna, kolumna + 1);  // zmieniamy na literę
    return litera + wiersz;
  } // koniec metody
    
  private int obliczWierszZIndeksu(int indeks) {
    return indeks / PLANSZA_DLUGOSC;
  } // koniec metody
    
  private int getWartoscInkrementacji() {
    if (liczbaStartupow % 2 == 0) {                           // jeśli to parzysty startup
      return INKREMENTACJA_W_POZ;                             // rozmieszczamy w poziomie
    } else {                                                  // jeśli to nieparzysty startup
      return INKREMENTACJA_W_PION;                            // rozmieszczamy w pionie
    }
  } // koniec metody
  
}
