package rozdzial17;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;

import static java.nio.charset.StandardCharsets.UTF_8;

public class ProstyKlientPogawedekA {
  private JTextField wiadomosc;
  private PrintWriter pisarz;

  public void doDziela() {
    konfigurujKomunikacje();

    wiadomosc = new JTextField(20);

    JButton przyciskWyslij = new JButton("Wyślij");
    przyciskWyslij.addActionListener(e -> wyslijWiadomosc());

    JPanel panelGlowny = new JPanel();
    panelGlowny.add(wiadomosc);
    panelGlowny.add(przyciskWyslij);

    JFrame ramka = new JFrame("Śmiesznie prosty klient pogawędek");
    ramka.getContentPane().add(BorderLayout.CENTER, panelGlowny);
    ramka.setSize(400, 100);
    ramka.setVisible(true);
    ramka.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
  }

  private void konfigurujKomunikacje() {
    try {
      InetSocketAddress adresSerwera = new InetSocketAddress("127.0.0.1", 5000);
      SocketChannel kanalSC = SocketChannel.open(adresSerwera);
      pisarz = new PrintWriter(Channels.newWriter(kanalSC, UTF_8));
      System.out.println("Obsługa sieci gotowa. Adres klienta: " + kanalSC.getLocalAddress());
    } catch (IOException ex) {
      ex.printStackTrace();
    }
  }

  private void wyslijWiadomosc() {
    pisarz.println(wiadomosc.getText());
    pisarz.flush();
    wiadomosc.setText("");
    wiadomosc.requestFocus();
  }

  public static void main(String[] args) {
    new ProstyKlientPogawedekA().doDziela();
  }
}