package rozdzial13;

import javax.sound.midi.*;
import static javax.sound.midi.ShortMessage.*; 

public class MiniMuzaAplkWrsPlc { 
  public static void main(String[] args) {
    MiniMuzaAplkWrsPlc mini = new MiniMuzaAplkWrsPlc();
    if (args.length < 2) {
      System.out.println("Nie zapomnij podać argumentów określających instrument i nutę");
    } else {
      int instrument = Integer.parseInt(args[0]);
      int nuta = Integer.parseInt(args[1]);
      mini.graj(instrument, nuta);
    }
  }

  public void graj(int instrument, int nuta) {

    try {

      Sequencer sekwenser = MidiSystem.getSequencer();
      sekwenser.open();

      Sequence sekw = new Sequence(Sequence.PPQ, 4);
      Track sciezka = sekw.createTrack();

      ShortMessage msg1 = new ShortMessage();
      msg1.setMessage(PROGRAM_CHANGE, 1, instrument, 0);
      MidiEvent zmienInstrument = new MidiEvent(msg1, 1);
      sciezka.add(zmienInstrument);

      ShortMessage msg2 = new ShortMessage();
      msg2.setMessage(NOTE_ON, 1, nuta, 100);
      MidiEvent nutaPocz = new MidiEvent(msg2, 1);
      sciezka.add(nutaPocz);

      ShortMessage msg3 = new ShortMessage();
      msg3.setMessage(NOTE_OFF, 1, nuta, 100);
      MidiEvent nutaKon = new MidiEvent(msg3, 16);
      sciezka.add(nutaKon);

      sekwenser.setSequence(sekw);
      sekwenser.start();

    } catch (Exception ex) {
      ex.printStackTrace();
    }
  } 
}
