package rozdzial06;

import java.util.ArrayList;

public class StartupGraMax {
  private PomocnikGry pomocnik = new PomocnikGry();
  private ArrayList<Startup> startupy = new ArrayList<Startup>();
  private int liczbaRuchow = 0;
  
  private void przygotujGre() {
    //  najpierw tworzymy portale i określamy ich położenie
    Startup pierwszy = new Startup();
    pierwszy.setNazwa("poniez");
    Startup drugi = new Startup();
    drugi.setNazwa("hacqi");
    Startup trzeci = new Startup();
    trzeci.setNazwa("cabista");
    startupy.add(pierwszy);
    startupy.add(drugi);
    startupy.add(trzeci);
    
    System.out.println("Twoim celem jest zatopienie trzech startupów.");
    System.out.println("poniez, hacqi, cabista");
    System.out.println("Postaraj się je zatopić, wykonując jak najmniej ruchów.");
    
    for (Startup startup : startupy) {
      ArrayList<String> nowePolozenie = pomocnik.rozmiescStartup(3);
      startup.setPolaPolozenia(nowePolozenie);
    } // koniec pętli for
  } // koniec metody
  
  private void rozpocznijGre() {
    while (!startupy.isEmpty()) {
      String ruchGracza = pomocnik.pobierzDaneWejsciowe("Podaj pole: ");
      sprawdzRuchGracza(ruchGracza);
    } // koniec pętli while
    zakonczGre();
  } // koniec metody  
  
  
  private void sprawdzRuchGracza(String ruchGracza) {
    liczbaRuchow++;
    String wynik = "pudło";
    for (Startup startupDoSprawdzenia : startupy) {
      wynik = startupDoSprawdzenia.sprawdz(ruchGracza);
      if (wynik.equals("trafiony")) {
        break;
      }
      if (wynik.equals("zatopiony")) {
        startupy.remove(startupDoSprawdzenia);
        break;
      }
    } // koniec pętli for
    System.out.println(wynik);
  } // koniec metody
    
  private void zakonczGre() {
    System.out.println("Wszystkie startupy zostały zatopione! Teraz Twoje informacje nie mają znaczenia.");
    if (liczbaRuchow <= 18) {
      System.out.println("Wykonałeś jedynie " + liczbaRuchow + " ruchów.");
      System.out.println("Wydostałeś się, zanim Twoje informacje zatonęły.");      
    } else {
      System.out.println("Ale się grzebałeś! Wykonałeś aż "+ liczbaRuchow + " ruchów.");
      System.out.println("Teraz rybki pływają pomiędzy Twoimi informacjami.");
           
    }
  } // koniec metody
    
  public static void main(String[] args) {
    StartupGraMax gra = new StartupGraMax();
    gra.przygotujGre();
    gra.rozpocznijGre();
  } // koniec metody
  
}
