package rozdzial18.monikairobert;


import java.util.concurrent.*;

public class MonikaIRobertTest {
  public static void main(String[] args) throws InterruptedException {
    for (int i = 0; i < 10; i++) {
      final KontoBankowe account = new KontoBankowe();
      MonikaIRobert robert = new MonikaIRobert("Robert", account, 50);
      MonikaIRobert monika = new MonikaIRobert("Monika", account, 100);
      ExecutorService wykonawca = Executors.newFixedThreadPool(2);
      wykonawca.execute(robert);
      wykonawca.execute(monika);
      wykonawca.shutdown();
      //wykonawca.awaitTermination(1, TimeUnit.MINUTES);
      //System.out.println("---");
    }
  }
}

class MonikaIRobert implements Runnable {
  private final String imie;
  private final KontoBankowe konto;
  private final int kwotaDoWydania;

  MonikaIRobert(String imie, KontoBankowe konto, int kwotaDoWydania) {
    this.imie = imie;
    this.konto = konto;
    this.kwotaDoWydania = kwotaDoWydania;
  }

  public void run() {
    zrobZakupy(kwotaDoWydania);
  }

  private void zrobZakupy(int kwota) {
    if (konto.getStan() >= kwota) {
      System.out.println(imie + " zamierza wydać trochę pieniędzy.");
      konto.wydaj(kwota);
      System.out.println(imie + " kończy zakupy.");
    } else {
      System.out.println("Przykro mi, nie masz tylu pieniędzy, " + imie + ".");
    }
  }
}

class KontoBankowe {
  private int stan = 100;

  public int getStan() {
    return stan;
  }

  public void wydaj(int kwota) {
    stan = stan - kwota;
    if (stan < 0) {
      System.out.println("Przekroczenie limitu!");
    }
  }
}


