package rozdzial17;


import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class CzasNaZakonczenie {
  public static void main(String[] args) throws InterruptedException {
    ExecutorService pulaWatkow = Executors.newFixedThreadPool(2);
    pulaWatkow.execute(new DlugieZadanie("Długie zadanie"));
    pulaWatkow.execute(new KrotkieZadanie("Krotkie zadanie"));
    pulaWatkow.shutdown();

    try {
      boolean czyZakonczona = pulaWatkow.awaitTermination(5, TimeUnit.SECONDS);
      System.out.println("Zakończona? " + czyZakonczona);
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
    pulaWatkow.shutdownNow();
  }

  static void pelneZamkniecie() throws InterruptedException {
    ExecutorService threadPool = Executors.newFixedThreadPool(2);
    threadPool.execute(new DlugieZadanie("Długie zadanie 1"));
    threadPool.execute(new KrotkieZadanie("Krótkie zadanie"));
    threadPool.execute(new DlugieZadanie("Długie zadanie 2"));
    threadPool.execute(new DlugieZadanie("Długie zadanie 3"));
    threadPool.execute(new DlugieZadanie("Długie zadanie 4"));
    threadPool.execute(new KrotkieZadanie("Nie należy uruchamiać zadania"));
    threadPool.shutdown();
    KrotkieZadanie tooLateJob = new KrotkieZadanie("Spóźnione zadanie");
    try {
      threadPool.execute(tooLateJob);
    } catch (RejectedExecutionException ex) {
      System.out.println("Zbyt późno na uruchomienie nowego zadania!! " + tooLateJob);
    }
    threadPool.awaitTermination(4, TimeUnit.SECONDS);

    List<Runnable> unfinished = threadPool.shutdownNow();

    System.out.println("unfinished.size() = " + unfinished.size());
    for (Runnable runnable : unfinished) {
      System.out.println(runnable);
    }

  }

  static void shutdownGracefully() {
    ExecutorService threadPool = Executors.newFixedThreadPool(2);
    threadPool.execute(new DlugieZadanie("Dugie zadanie 1"));
    threadPool.execute(new KrotkieZadanie("Krótkie zadanie"));
    threadPool.execute(new DlugieZadanie("Dugie zadanie 2"));
    threadPool.execute(new KrotkieZadanie("Zadanie dodane do kolejki"));
    threadPool.shutdown();
    KrotkieZadanie tooLateJob = new KrotkieZadanie("Spóźnione zadanie");
    try {
      threadPool.execute(tooLateJob);
    } catch (RejectedExecutionException ex) {
      System.out.println("Zbyt późno na uruchomienie nowego zadania!! " + tooLateJob);
    }
    System.out.println("threadPool.isShutdown() = " + threadPool.isShutdown());
    System.out.println("threadPool.isTerminated() = " + threadPool.isTerminated());

    try {
      boolean poolFinished = threadPool.awaitTermination(100, TimeUnit.SECONDS);
      System.out.println("Zakończona? " + poolFinished);
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
    System.out.println("threadPool.isShutdown() = " + threadPool.isShutdown());
    System.out.println("threadPool.isTerminated() = " + threadPool.isTerminated());
  }

  static void shutdownGracefullyWorkstealing() {
    ExecutorService threadPool = Executors.newWorkStealingPool(2);
    threadPool.execute(new DlugieZadanie("Dugie zadanie 1"));
    threadPool.execute(new KrotkieZadanie("Krótkie zadanie"));
    threadPool.execute(new DlugieZadanie("Dugie zadanie 2"));
    threadPool.execute(new KrotkieZadanie("Zadanie dodane do kolejki"));
    threadPool.shutdown();
    KrotkieZadanie tooLateJob = new KrotkieZadanie("Spóźnione zadanie");
    try {
      threadPool.execute(tooLateJob);
    } catch (RejectedExecutionException ex) {
      System.out.println("Zbyt późno na uruchomienie nowego zadania!! " + tooLateJob);
    }
    System.out.println("threadPool.isShutdown() = " + threadPool.isShutdown());
    System.out.println("threadPool.isTerminated() = " + threadPool.isTerminated());

    try {
      System.out.println("Zakończona? " + threadPool.awaitTermination(4, TimeUnit.SECONDS));
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
    System.out.println("threadPool.isShutdown() = " + threadPool.isShutdown());
    System.out.println("threadPool.isTerminated() = " + threadPool.isTerminated());
  }

  static void forceShutdown() {
    ExecutorService threadPool = Executors.newFixedThreadPool(2);
    threadPool.execute(new DlugieZadanie("Dugie zadanie 1"));
    threadPool.execute(new KrotkieZadanie("Krótkie zadanie"));
    threadPool.execute(new DlugieZadanie("Dugie zadanie 2"));
    threadPool.execute(new KrotkieZadanie("Shouldn't start job"));
    List<Runnable> unfinished = threadPool.shutdownNow();

    System.out.println("unfinished.size() = " + unfinished.size());
    for (Runnable runnable : unfinished) {
      System.out.println(runnable);
    }
  }

  static void forceShutdownWorkStealing() {
    ExecutorService threadPool = Executors.newWorkStealingPool(2);
    threadPool.execute(new DlugieZadanie("Dugie zadanie 1"));
    threadPool.execute(new KrotkieZadanie("Krótkie zadanie"));
    threadPool.execute(new DlugieZadanie("Dugie zadanie 2"));
    threadPool.execute(new KrotkieZadanie("Shouldn't start job"));
    List<Runnable> unfinished = threadPool.shutdownNow();
    try {
      System.out.println("Zakończona? " + threadPool.awaitTermination(1, TimeUnit.SECONDS));
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }

    System.out.println("unfinished.size() = " + unfinished.size());
    for (Runnable runnable : unfinished) {
      System.out.println(runnable);
    }
  }

}

abstract class NazwaneZadanie implements Runnable {
  protected String nazwaZadania;

  NazwaneZadanie(String nazwa) {
    this.nazwaZadania = nazwa;
  }

  @Override
  public String toString() {
    return "NazwaneZadanie{" +
            "nazwaZadania='" + nazwaZadania + '\'' +
            '}';
  }
}

class KrotkieZadanie extends NazwaneZadanie {
  KrotkieZadanie(String nazwa) {
    super(nazwa);
  }

  public void run() {
    System.out.println(nazwaZadania);
  }
}

class DlugieZadanie extends NazwaneZadanie {
  DlugieZadanie(String nazwa) {
    super(nazwa);
  }

  public void run() {
    try {
      TimeUnit.SECONDS.sleep(3);
      System.out.println(nazwaZadania);
    } catch (InterruptedException ex) {
      System.out.println("Przerwano zadanie: " + nazwaZadania);
      ex.printStackTrace();
    }
  }
}
