package rozdzial17;

import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;
import java.util.Random;

public class CodziennePoradySerwer {
  final private String[] listaPorad = {
    "Używaj mniejszych bitów", 
    "Chodź w dopasowanych spodniach. Nie, te nie sprawiają, że wyglądasz grubo.", 
    "Jedno słowo: nieodpowiednie", 
    "Tylko dziś - bądź uczciwy. Powiedz swojemu szefowi, co *naprawdę* czujesz", 
    "Może chcesz się zastanowić nad swoją fryzurą?"};
          
          
  private final Random losowa = new Random();

  public void Roboty() {
    try (ServerSocketChannel kanalSerwera = ServerSocketChannel.open()) {
      kanalSerwera.bind(new InetSocketAddress(5000));

      while (kanalSerwera.isOpen()) {
        SocketChannel kanalKlienta = kanalSerwera.accept();
        PrintWriter pisarz = new PrintWriter(Channels.newOutputStream(kanalKlienta));
        
        String porada = pobierzPorade();
        pisarz.println(porada);
        pisarz.close();
        System.out.println(porada);
      }

    } catch (IOException ex) {
      ex.printStackTrace();
    }
  }

  private String pobierzPorade() {
    int nastepnaPorada = losowa.nextInt(listaPorad.length);
    return listaPorad[nastepnaPorada];
  }

  public static void main(String[] args) {
    new CodziennePoradySerwer().Roboty();
  }
}