package rozdzial14;

import javax.sound.midi.*;
import static javax.sound.midi.ShortMessage.*;

public class Miniodtwarzacz1 {
  public static void main(String[] args) {
    try {
      Sequencer sekwenser = MidiSystem.getSequencer();
      sekwenser.open();
      Sequence sekw = new Sequence(Sequence.PPQ, 4);
      Track sciezka = sekw.createTrack();

      for (int i = 5; i < 61; i+=4) {
        sciezka.add(tworzZdarzenie(NOTE_ON,1,i,100,i));
        sciezka.add(tworzZdarzenie(NOTE_OFF,1,i,100,i + 2));
      } 

      sekwenser.setSequence(sekw);
      sekwenser.setTempoInBPM(220);
      sekwenser.start();
    } catch (Exception ex) { 
      ex.printStackTrace(); 
    }
  } 

  public static MidiEvent tworzZdarzenie(int plc, int kanal, int jeden, int dwa, int takt) {
    MidiEvent zdarzenie = null;
    try {
      ShortMessage msg = new ShortMessage();
      msg.setMessage(plc, kanal, jeden, dwa);
      zdarzenie = new MidiEvent(msg, takt);
    } catch(Exception ex) { 
      ex.printStackTrace();
    }
    return zdarzenie;
  }
} 
