package rozdzial14;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class DwaPrzyciski {

  private JFrame ramka;
  private JLabel etykieta;

  public static void main(String[] args) {
    DwaPrzyciski gui = new DwaPrzyciski();
    gui.doRoboty();
  }

  public void doRoboty() {
    ramka = new JFrame();
    ramka.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    JButton przyciskEtykieta = new JButton("Zmień etykietę");
    przyciskEtykieta.addActionListener(new EtykietaListener());

    JButton przyciskKolor = new JButton("Zmień kolor");
    przyciskKolor.addActionListener(new KolorListener());

    etykieta = new JLabel("Oto etykieta");
    MojPanelRysunkowy panel = new MojPanelRysunkowy();

    ramka.getContentPane().add(BorderLayout.SOUTH, przyciskKolor);
    ramka.getContentPane().add(BorderLayout.CENTER, panel);
    ramka.getContentPane().add(BorderLayout.EAST, przyciskEtykieta);
    ramka.getContentPane().add(BorderLayout.WEST, etykieta);

    ramka.setSize(500, 400);
    ramka.setVisible(true);
  }

  class EtykietaListener implements ActionListener {
    public void actionPerformed(ActionEvent zdarzenie) {
      etykieta.setText("Auuuuuu!");
    }
  } // koniec klasy wewnętrznej

  class KolorListener implements ActionListener {
    public void actionPerformed(ActionEvent zdarzenie) {
      ramka.repaint();
    }
  } // koniec klasy wewnętrznej
}
