// Zastosowanie klauzul case ze strzałką w instrukcji switch. Ten przykład
// używa instrukcji switch w celu zliczania produktów wytwarzanych
// przez trzy symulowane linie produkcyjne
class StatementSwitchWithArrows {

  public static void main(String[] args) {
    // Liczniki poszczególnych linii produkcyjnych
    int line1count = 0;
    int line2count = 0;
    int line3count = 0;

    // Numer linii produkcyjnej
    int productionLine;

    for(int i=1; i < 10; i++) {
      // Symulujemy wytworzenie produktu przez jedną z linii produkcyjnych
      productionLine = (i % 3) + 1;

      // Używamy klauzul case ze strzałką w instrukcji switch. Zwróć uwagę,
      // że instrukcja nie zwraca żadnych wartości (nie jest używane
      // słowo kluczowe yield). Zamiast tego na podstawie numeru linii, która wytworzyła
      // produkt, jest aktualizowany odpowiedni licznik i wyświetlany stosowny komunikat
      switch(productionLine) {
        case 1 -> { line1count++;
                    System.out.println("Produkt wytworzony przez linię nr 1");
                  }
        case 2 -> { line2count++;
                    System.out.println("Produkt wytworzony przez linię nr 2");
                  }
        case 3 -> { line3count++;
                    System.out.println("Produkt wytworzony przez linię nr 3");
                  }
      }
    }

    System.out.println("Liczby produktów wytworzonych przez linie 1, 2 i 3: " + 
                        line1count + ", " + line2count + ", " + line3count);
  }
}
